from ast import alias
from typing import Text
import bpy
from bpy.types import UIList
from numpy import True_
import json
import os
from .hair import update_hair_values_on_panel
import textwrap
from bpy.app.handlers import persistent
from  . hair import BlockHandler



def _label_multiline(context, text, parent):
    chars = int(context.region.width / 7)   # 7 pix on 1 character
    wrapper = textwrap.TextWrapper(width=chars)
    text_lines = wrapper.wrap(text=text)
    for text_line in text_lines:
        parent.label(text=text_line)

def stop_playback(scene):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_stop_loop:
        if scene.frame_current == scene.frame_end:
            bpy.ops.screen.animation_cancel(restore_frame=False)

# # or restore frames:

@persistent
def hair_list_handler(scene):
    global BLOCK_HANDLER_UPDT

    if bpy.context.active_object is not None:

        #checa se handler pode rodar, as vezes e importante trvar o handler para executar alguns comandos, como por exemplo o delete, senao ele age antes do que deveria
        if BlockHandler.value == 0 :

            qty_particles = len(bpy.context.active_object.particle_systems)
            qty_ob_partic = len(bpy.context.active_object.hair_list)

            if qty_particles > 0:
                if qty_ob_partic == 0:
                    for i,hair_partic in enumerate(bpy.context.active_object.particle_systems):
                        bpy.context.active_object.hair_list.add()
                        bpy.context.active_object.hair_list[i].name = hair_partic.name
                        bpy.context.active_object.hair_list[i].orig_name = hair_partic.name
                        bpy.context.active_object.hair_list[i].particle_system_id = i
                elif qty_particles > qty_ob_partic:
                    obj_orig_names = []
                    obj_orig_names = []
                    for obj_part in bpy.context.active_object.hair_list:
                        obj_orig_names.append(obj_part.name) #gera lista de nomes para comparar com nomes das particulas
                        # obj_orig_names.append(obj_part.orig_name) 
                    for part in bpy.context.active_object.particle_systems:
                        if part.name not in obj_orig_names: #checa se falta alguma particula
                            print('nao tem: ',part.name)
                            i = len(bpy.context.active_object.hair_list) #pego o len por que como vou usar como id (que comeca em zero) ele ja estaria com o novo valor de id, eu nao precisaria acrescentar +1
                            bpy.context.active_object.hair_list.add()
                            bpy.context.active_object.hair_list[i].name = part.name
                            bpy.context.active_object.hair_list[i].orig_name = part.name
                            bpy.context.active_object.hair_list[i].particle_system_id = i
                    #apos reinserir os dados, e necessario checar se todos os ids estao corretos
                    for partic_id,part in enumerate(bpy.context.active_object.particle_systems):
                        for obj_part in bpy.context.active_object.hair_list:
                            if part.name == obj_part.orig_name and obj_part.particle_system_id != partic_id: #se o nome for igaal, mas o id diferente, atualizar id no hair_part
                                print('ajustar id')
                                obj_part.particle_system_id = partic_id
                elif qty_particles < qty_ob_partic: # se tiver mais particulas listadas do que realmente existem
                    part_names = []
                    for part in bpy.context.active_object.particle_systems:
                        part_names.append(part.name) #gera lista de nomes para comparar com nomes das particulas
                    obj_orig_name_to_remove = []
                    for obj_part in bpy.context.active_object.hair_list:
                        if obj_part.orig_name not in part_names: #checa se falta alguma particula
                            print('nao tem, tem qeu retirar: ',obj_part.orig_name)
                            obj_orig_name_to_remove.append(obj_part.orig_name)
                    
                    #apos montar a lista do que retirar, retirar os nomes da listagem no objeto
                    #setar primeiro o index_list para ser o primeiro, para evitar erros
                    bpy.context.active_object.hair_list_index = 0
                    
                    hair_list = bpy.context.active_object.hair_list
                    for i_hair_remove,hair_remove_from_list in enumerate(hair_list):
                        if hair_remove_from_list.orig_name in obj_orig_name_to_remove:
                            hair_list.remove(i_hair_remove)
                else: #nesse caso, sobra apenas se a quantidade for igual antre ambos, vale aqui checar se os IDs entre a lista e as particulas es~toa corretos.
                    part_names = []
                    for part in bpy.context.active_object.particle_systems:
                        part_names.append(part.name) #gera lista de nomes para comparar com nomes das particulas
                    for i,p_name in enumerate(part_names): #o "i" seria o id do particle
                        for idx_hl,hair_list in enumerate(bpy.context.active_object.hair_list):
                            if hair_list.orig_name == p_name and hair_list.particle_system_id != i:
                                bpy.context.active_object.hair_list[idx_hl].particle_system_id = i
        

            ######
            ## Children
            dyna_groom = bpy.context.scene.dyna_groom_prop
            idx = bpy.context.active_object.hair_list_index
            idx_particle = bpy.context.active_object.hair_list[idx].particle_system_id
            if bpy.context.object.particle_systems[idx_particle].settings.child_type == 'NONE' and not dyna_groom.bool_children_none:
                dyna_groom.bool_children_none = True
            elif bpy.context.object.particle_systems[idx_particle].settings.child_type == 'SIMPLE' and not dyna_groom.bool_children_simple:
                dyna_groom.bool_children_simple = True
            elif bpy.context.scene.tool_settings.particle_edit.select_mode == 'INTERPOLATED' and not dyna_groom.bool_children_interpolated:
                dyna_groom.bool_children_interpolated = True
            
            if bpy.context.object.particle_systems[idx_particle].settings.child_type == 'SIMPLE' :
                dyna_groom.bool_children_parting = False #so pra nao ficar aparecendo informacao que nao sera util


        

        dyna_groom = bpy.context.scene.dyna_groom_prop
        if bpy.context.scene.tool_settings.particle_edit.select_mode == 'PATH' and not dyna_groom.bool_editmode_path:
            dyna_groom.bool_editmode_path = True
        elif bpy.context.scene.tool_settings.particle_edit.select_mode == 'POINT' and not dyna_groom.bool_editmode_point:
            dyna_groom.bool_editmode_point = True
        elif bpy.context.scene.tool_settings.particle_edit.select_mode == 'TIP' and not dyna_groom.bool_editmode_tip:
            dyna_groom.bool_editmode_tip = True

###### Handle para cuidar da atualizacao da influencia
@persistent
def handler_hair_shapekey_index_fullstack(scene):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_enable_shapekey:
        idx = bpy.context.active_object.hair_list_index
        idx_particle = bpy.context.active_object.hair_list[idx].particle_system_id
        hair_settings = bpy.context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        # hair_list_shapekey_index = hair_settings.particle_shape_index



        load_base = json.loads(hair_list_shapekey[0].partic_data)
        for i_ps,ps in enumerate(hair_list_shapekey):
            # print (i_ps,' - ',ps.partic_name)
            # if i_ps ==1: #guada a informacao da base shapekey
            #     load_last = load_base
            if i_ps >= 1: #no i_ps =1 o last é  load_base, por isso o post_influence esta vazio
                if i_ps == 1:
                    load_last = load_base
                else:
                    load_last = json.loads(hair_settings.particle_shape[i_ps-1].partic_data_post_influence)
                    # load_last = json.loads(hair_settings.particle_last_shape)
                #carrega dado atual
                load_hair = json.loads(ps.partic_data)
                influence = ps.partic_shapekey_influence

                bpy.ops.object.mode_set(mode='OBJECT')
                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active

                precision = 4
                precision_string = "{:."+str(precision)+"f}" #ajuste necessario pois, apesar de nao mover alguns pontos, propositalmente, eles acabam sendo movimentados, e isso bagunca o funcionamento

                # for p,base,l_last,hair in zip(particle_system.particles,load_base,load_last,load_hair): #fios de cabelo
                for i_h,hair_strand in enumerate(zip(particle_system.particles,load_base,load_last,load_hair)): #fios de cabelo
                    p = hair_strand[0]
                    base = hair_strand[1]
                    l_last = hair_strand[2]
                    hair = hair_strand[3]
                    # for v,b,ll,h in zip(p.hair_keys,base,l_last,hair): #ponto dos fios de cabelo "keys"
                    for i_h_key,hair_keys in enumerate(zip(p.hair_keys,base,l_last,hair)): #ponto dos fios de cabelo "keys"
                        v = hair_keys[0]
                        b = hair_keys[1]
                        ll = hair_keys[2]
                        h = hair_keys[3]
                        # print(i_h,'-',i_h_key)
                        # if b[0] != h[0]:
                        # if "{:.4f}".format(b[0]) != "{:.4f}".format(h[0]) :
                        if precision_string.format(b[0]) != precision_string.format(h[0]) :
                            v.co[0] = ll[0]+((h[0] - ll[0]) * influence)
                        else:
                            v.co[0] = ll[0]
                        # if b[1] != h[1]:
                        # if "{:.4f}".format(b[1]) != "{:.4f}".format(h[1]) :
                        if precision_string.format(b[1]) != precision_string.format(h[1]) :
                            v.co[1] = ll[1]+((h[1] - ll[1]) * influence)
                        else:
                            v.co[1] = ll[1]
                        # if b[2] != h[2]:
                        # if "{:.4f}".format(b[2]) != "{:.4f}".format(h[2]) :
                        if precision_string.format(b[2]) != precision_string.format(h[2]) :
                                v.co[2] = ll[2]+((h[2] - ll[2]) * influence)
                        else:
                            v.co[2] = ll[2]

                #ao terminar de rodar todos os fios de cabelo
                bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
                bpy.ops.object.mode_set(mode='OBJECT') #fixar os valores

                    # Apos processar, guardar a nva forma na propriedade particle_last_shape


                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active
                
                hairs = []

                for p in particle_system.particles:
                    hair = []
                    for v in p.hair_keys:
                        hair.append([v.co[0], v.co[1], v.co[2]])
                    hairs.append(hair)

                hairs____ = hairs
                
                save_hairs = json.dumps(hairs)
                # hair_settings.particle_last_shape = save_hairs
                ps.partic_data_post_influence = save_hairs

@persistent
def stop_playback_restore(scene):
    if scene.frame_current == scene.frame_end + 1:
        bpy.ops.screen.animation_cancel(restore_frame=True)


# pre_handlers = bpy.app.handlers.depsgraph_update_pre
pre_handlers = bpy.app.handlers.depsgraph_update_post
[pre_handlers.remove(h) for h in pre_handlers if h.__name__ == "hair_list_handler"]
pre_handlers.append(hair_list_handler)

# handler_hair_shapekey_index_fullstack
pre_frame_handlers = bpy.app.handlers.frame_change_pre
[pre_frame_handlers.remove(f) for f in pre_frame_handlers if f.__name__ == "stop_playback" or f.__name__ =="handler_hair_shapekey_index_fullstack"]
pre_frame_handlers.append(handler_hair_shapekey_index_fullstack)
pre_frame_handlers.append(stop_playback)

class MY_UL_List(UIList):

    def draw_item(self, context, layout, data, item, icon, active_data,
                  active_propname, index):

        # We could write some code to decide which icon to use here...
        custom_icon = 'PARTICLES'

        # Make sure your code supports all 3 layout types
        if self.layout_type in {'DEFAULT', 'COMPACT'}:
            split = layout.split(factor=0.8)
            # split.label(text="Index: %d" % (index))
            # if bpy.context.object.particle_systems[h[0]-1].use_hair_dynamics == False:
            #     dyna_on = split.operator('hair.hair_dynamics_on',text='',icon="RADIOBUT_OFF")
            #     dyna_on.hair_id = index ## trocar depois pela forma correta, que é pegando pelo particle_system_id
            # else:
            #     dyna_on = split.operator('hair.hair_dynamics_off',text='',icon="RADIOBUT_ON")
            #     dyna_on.hair_id = index

            split.label(text=item.name, icon = custom_icon)
            # layout.label(text=item.name, icon = custom_icon)
            
            # layout.prop(item, "name", text="", emboss=False, icon_value=custom_icon)

        elif self.layout_type in {'GRID'}:
            layout.alignment = 'CENTER'
            layout.label(text="", icon = custom_icon)

class HAIR_UL_ShapekeyList(UIList):
    def draw_item(self, context, layout, data, item, icon, active_data,
                  active_propname, index):

        # We could write some code to decide which icon to use here...
        custom_icon = 'OUTLINER_DATA_CURVES'

        # Make sure your code supports all 3 layout types
        if self.layout_type in {'DEFAULT', 'COMPACT'}:
            split = layout.split(factor=0.8)
            split.label(text=item.partic_name, icon = custom_icon)

        elif self.layout_type in {'GRID'}:
            layout.alignment = 'CENTER'
            layout.label(text="", icon = custom_icon)



class HD_PT_PanelDynaGroom(bpy.types.Panel):
    bl_idname = "HD_PT_DYNAMIC_GROOMING"
    bl_label = "Dynamic Grooming "
    bl_category = "CEB"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"

    
    def draw(self, context):
        layout = self.layout
        scene = context.scene
        active_ob = context.active_object
        if active_ob is not None:
            dyna_groom = context.scene.dyna_groom_prop
            
            qty_particles = len(bpy.context.active_object.particle_systems)
            qty_ob_partic = len(bpy.context.active_object.hair_list)


            if qty_particles == qty_ob_partic and  len(context.active_object.hair_list) > 0 :
                idx = context.active_object.hair_list_index
                if idx > len(context.active_object.hair_list) -1:
                    row = layout.row()
                    row.operator('hair.updt_particle_current')
                else:
                    idx_particle = context.active_object.hair_list[idx].particle_system_id
            # if dyna_groom.str_json_sections != '':
            #     hair_sections = json.loads(dyna_groom.str_json_sections)
            # if dyna_groom.enum_hair_curr_section == '':
            #     id_to_update_name = 1
            # else:
            #     id_to_update_name = dyna_groom.enum_hair_curr_section
            
            
            row = layout.row()
            row.label(text='CTRL + D for Pie Menu')
            row = layout.row()
            row.prop(dyna_groom,'bool_panel_hair_layer',toggle=True)

            #######################################################
            ###### Hair Layer Control
            if dyna_groom.bool_panel_hair_layer:
                if len(bpy.context.active_object.particle_systems) == len(bpy.context.active_object.hair_list):
                    #UI List
                    rows = 4
                    row = layout.row()
                    # row.template_list("MY_UL_List", "The_List", scene,"hair_list", scene, "hair_list_index")
                    # row.template_list("MY_UL_List", "The_List", active_ob,"hair_list", active_ob, "hair_list_index")
                    row.template_list("MY_UL_List", "The_List", active_ob,"hair_list", active_ob, "hair_list_index",rows=rows)
                    col = row.column(align=True)
                    # row = layout.row()
                    col.operator('hair_list.new_item', text='',icon='ADD')
                    col.operator('hair_list.delete_item', text='',icon='REMOVE')
                    col.separator()
                    col.operator('hair_list.move_item', text='',icon='TRIA_UP').direction = 'UP'
                    col.operator('hair_list.move_item', text='',icon='TRIA_DOWN').direction = 'DOWN'

                else:
                    row = layout.row()
                    row_large = row.row()
                    row_large.scale_y = 2
                    row_large.operator('hair.updt_particle_list')

                if context.active_object.hair_list_index >= 0 and context.active_object.hair_list:
                    item = context.active_object.hair_list[context.active_object.hair_list_index]

                    row = layout.row()
                    row.prop(item, "name",text='')
                    

                    ######################
                    rowb = layout.row().box()
                    row = rowb.row()
                    # row.enabled = enable_ctr
                    row.enabled = True
                    row.prop(scene, "ceb_dyna_groom_colapse_vg",
                    icon="TRIA_DOWN" if scene.ceb_dyna_groom_colapse_vg else "TRIA_RIGHT",
                    icon_only=True, emboss=False
                    )
                    row.label(text='Vertex Groups : ') 

                    if scene.ceb_dyna_groom_colapse_vg:
                            
                            row = rowb.column()
                    
                            # row = layout.row().box()
                            # row.label(text='Vertex Groups')
                            row.prop(dyna_groom, "enum_hair_vert_group_density",text='Density')
                            # row = layout.row()
                            row.prop(dyna_groom, "enum_hair_vert_group_length", text='Length')
                            # row = layout.row()
                            row.prop(dyna_groom, "enum_hair_vert_group_clump",text='Clump')
                            row.prop(dyna_groom, "enum_hair_vert_group_kink",text='Kink')
                            row.prop(dyna_groom, "enum_hair_vert_group_rough1",text='Roughness1')
                            row.prop(dyna_groom, "enum_hair_vert_group_rough2",text='Roughness2')
                            row.prop(dyna_groom, "enum_hair_vert_group_roughend",text='Roughness End')
                            row.prop(dyna_groom, "enum_hair_vert_group_twist",text='Twist')

                ####### Testar panel com Shapekeys
                if len(bpy.context.active_object.particle_systems) == len(bpy.context.active_object.hair_list) \
                    and len(bpy.context.active_object.hair_list) > 0 :
                    idx = context.active_object.hair_list_index
                    idx_particle = context.active_object.hair_list[idx].particle_system_id
                    # active_partic = context.object.particle_systems[idx_particle].settings
                    active_partic = context.active_object.particle_systems[idx_particle].settings
                    #UI List
                    rows = 2
                    # row = layout.row()
                    # row.label(text="ShapeKey Control: ")
                    # row = layout.row()


                    ######################
                    rowb = layout.row().box()
                    row = rowb.row()
                    # row.enabled = enable_ctr
                    row.enabled = True
                    row.prop(scene, "ceb_dyna_groom_colapse_shapekey",
                    icon="TRIA_DOWN" if scene.ceb_dyna_groom_colapse_shapekey else "TRIA_RIGHT",
                    icon_only=True, emboss=False
                    )
                    row.label(text='ShapeKey Control : ') 

                    if scene.ceb_dyna_groom_colapse_shapekey:
                            
                            row = rowb.row()
                            row.template_list("HAIR_UL_ShapekeyList", "Shapekey_List", active_partic,"particle_shape", active_partic, "particle_shape_index",rows=rows)
                            col = row.column(align=True)
                            # row = col.column()
                            col.operator('hair_list.create_hair_shapekey', text='',icon='ADD')
                            col.operator('hair_list.delete_hair_shapekey', text='',icon='REMOVE')
                            # col.separator()
                            # col.operator('hair_list.move_item', text='',icon='TRIA_UP').direction = 'UP'
                            # col.operator('hair_list.move_item', text='',icon='TRIA_DOWN').direction = 'DOWN'
                        
                        
                            if active_partic.particle_shape_index >= 0 and active_partic.particle_shape:
                                item = active_partic.particle_shape[active_partic.particle_shape_index]

                                layout.use_property_split = True
                                layout.use_property_decorate = True
                                row = layout.row()
                                row.prop(item, "partic_name")
                                if active_partic.particle_shape_index != 0:
                                    row = layout.row()
                                    if dyna_groom.bool_enable_shapekey:
                                        row.enabled=True
                                    else:
                                        row.enabled=False
                                    row.prop(item, "partic_shapekey_influence",slider=True)
                                layout.use_property_split = False
                                layout.use_property_decorate = False
                                row = layout.row()
                                row.prop(dyna_groom, "bool_enable_shapekey")
                                # row = layout.row()
                                # row.prop(dyna_groom, "bool_absolute_shapekey")
                                # row = layout.row()
                                # row.operator('hair.shapekey_apply_test')

                else:
                    
                    row = layout.row()
                    row_large = row.row()
                    row_large.scale_y = 2
                    row_large.operator('hair.updt_particle_list')
                
                






            
            ###### Hair Layer Control
            #######################################################


            

            row = layout.row()
            row.separator()
            # col = layout.column(align=True)
            col = layout.column(align=True).box()
            row = col.row(align=True)
            row.scale_y = 2
            row.prop(dyna_groom,'bool_panel_main',toggle=True)
            row.prop(dyna_groom,'bool_panel_dynamic',toggle=True)
            row.prop(dyna_groom,'bool_panel_edit',toggle=True)

            row = col.row(align=True)
            split = row.split(factor=1/3)
            rowsplit1=split.row(align=True)
            rowsplit1.prop(dyna_groom,'bool_panel_load',toggle=True,icon='EXPORT',text='')
            rowsplit1.prop(dyna_groom,'bool_panel_save',toggle=True,icon='IMPORT',text='')
            # row.separator()
            # row.separator()
            # row.separator()
            rowsplit2 = split.row(align=True)
            rowsplit2.prop(dyna_groom,'bool_panel_import',toggle=True,icon='APPEND_BLEND',text='')
            rowsplit2.prop(dyna_groom,'bool_panel_export',toggle=True,icon='FILE_TICK',text='')
            
            
            # row = col.row(align=True)
            # row2 = col.row(align=True)
            # row2.prop(dyna_groom,'bool_panel_import_export',toggle=True)
            # row2.prop(dyna_groom,'bool_panel_load',toggle=True)
            # row2.prop(dyna_groom,'bool_panel_save',toggle=True)


            ##################################################
            ###### List of Particles
            ###### With Dynamics, viewport and render buttons
            if qty_particles==qty_ob_partic and len(bpy.context.active_object.particle_systems)>0:
                idx = context.active_object.hair_list_index
                idx_particle = context.active_object.hair_list[idx].particle_system_id
                pre_row = layout.row()
                # row = layout.row().box()
                row = pre_row.box()
                row = row.column(align=True)
                # for h in hair_sections:
                for ih,hair in enumerate(context.active_object.hair_list):
                    i = 0
                    hair_name=''
                    pid = hair.particle_system_id
                    # lock_hair_layer = hair.bool_lock_hair_layer
                    for mod in bpy.context.object.modifiers:
                        if mod.type == 'PARTICLE_SYSTEM':
                            # if i == ih:
                            if i == pid:
                                # print(i)
                                hair_name = mod.name
                                # lock_hair_layer = hair.bool_lock_hair_layer
                                # print(hair_name)
                            i = i+1

                    # idx =context.scene.hair_list_index
                    # part_id = context.scene.hair_list[idx].particle_system_id
                    # part_id = hair.particle_system_id
                    
                    col = row.row(align=True)
                    if ih == context.active_object.hair_list_index:
                        # col.label(text=hair.name,icon='RESTRICT_SELECT_OFF')
                        col.operator('hair.select_hair_layer',text=hair.name,icon='RESTRICT_SELECT_OFF')
                        # select_hair.hair_id = part_id
                    else:
                        select_hair = col.operator('hair.select_hair_layer',text=hair.name,icon='RESTRICT_SELECT_ON',emboss=False,translate=False)
                        select_hair.hair_id = ih
                        # col.label(text=hair.name,icon='RESTRICT_SELECT_ON')

                    if bpy.context.object.particle_systems[pid].use_hair_dynamics == False:
                        dyna_on = col.operator('hair.hair_dynamics_on',text='',icon="RADIOBUT_OFF",emboss=False)
                        dyna_on.hair_id = pid
                    else:
                        dyna_on = col.operator('hair.hair_dynamics_off',text='',icon="RADIOBUT_ON",emboss=False)
                        dyna_on.hair_id = pid


                    if bpy.context.object.modifiers[hair_name].show_viewport == False:
                        show_vp_hair = col.operator('hair.show_viewport_hair',text='',icon="RESTRICT_VIEW_ON",emboss=False)
                        show_vp_hair.hair_id = pid
                        # show_vp_hair.hair_name = hair_name
                    else:
                        hide_vp_hair = col.operator('hair.hide_viewport_hair',text='',icon="RESTRICT_VIEW_OFF",emboss=False)
                        hide_vp_hair.hair_id = pid
                        # hide_vp_hair.hair_name = hair_name
                        # hide_vp_hair.hair_id = ih
                    if bpy.context.object.modifiers[hair_name].show_render == False:
                        show_render_hair = col.operator('hair.show_render_hair',text='',icon="RESTRICT_RENDER_ON",emboss=False)
                        show_render_hair.hair_id = pid
                        # show_render_hair.hair_id = ih
                    else:
                        hide_render_hair = col.operator('hair.hide_render_hair',text='',icon="RESTRICT_RENDER_OFF",emboss=False)
                        hide_render_hair.hair_id = pid
                        # hide_render_hair.hair_id = ih
                    # if lock_hair_layer:
                    if context.active_object.hair_list[ih].bool_lock_hair_layer:
                        unlock_hair_layer = col.operator('hair.unlock_hair_layer',text='',icon="UNLOCKED",emboss=False)
                        unlock_hair_layer.hair_id = ih
                    else:
                        lock_hair_layer = col.operator('hair.lock_hair_layer',text='',icon="LOCKED",emboss=False)
                        lock_hair_layer.hair_id = ih
                # row = layout.row(align=True)
                row = pre_row.column(align=True)
                row.operator('hair_list.select_item', text='',icon='TRIA_UP').direction = 'UP'
                row.operator('hair_list.select_item', text='',icon='TRIA_DOWN').direction = 'DOWN'


            if len(bpy.context.active_object.particle_systems) > 0 :
                # idx = context.active_object.hair_list_index
                # idx_particle = context.active_object.hair_list[idx].particle_system_id
                # row = layout.row().box()

                # row.label(text="Hair Quality")
                # row.operator("hair.hq_hair",icon = "PROP_ON")
                # row.operator("hair.mq_hair",icon = "PROP_CON") 
                # row.operator("hair.lq_hair",icon = "PROP_OFF") 
                
                row = layout.row()
                row.separator()
                row = layout.row(align=True)
                row.operator("hair.toggle_particle_context", text="Toggle Context", icon="ARROW_LEFTRIGHT")
                row_part_clear = row.row()
                if bpy.context.object.particle_systems[idx_particle].is_edited:
                    row_part_clear.enabled = True
                else:
                    row_part_clear.enabled = False
                row_part_clear.operator("hair.particle_edit_clear",text='Clear Particle',icon = "GHOST_ENABLED") 
            
            ###### List of Particles
            ###### With Dynamics, viewport and render buttons
            ##################################################


            #########################################################
            ###### Painel Main
            # row = layout.row()
            if dyna_groom.bool_panel_main:
                
            
                ## Menu opcoes
                row = layout.column(align=True)
                row_part_edit = row.row()
                if context.mode == 'PARTICLE':
                    row_part_edit.enabled = True
                else:
                    row_part_edit.enabled = False

                # row_part_edit.prop(dyna_groom,'bool_hair_part_mode_opt',toggle=True)
                row = row.row(align=True)
                row.prop(dyna_groom,'bool_hair_opt',toggle=True)
                row.prop(dyna_groom,'bool_children_opt',toggle=True)
                row.prop(dyna_groom,'bool_hair_shape_opt',toggle=True)

            # row = layout.row().box()
            if qty_particles==qty_ob_partic and len(bpy.context.active_object.particle_systems)>0:
                if dyna_groom.bool_panel_main:
                    # if dyna_groom.bool_hair_opt or dyna_groom.bool_children_opt or dyna_groom.bool_hair_shape_opt:
                    #     ### tratamento para poder nao ficar sobrendo uma caixa vazia caso nao se escolha hair ou children ou shape
                    #     row = layout.row().box()
                    #     row = row.column(align=True)
                    
                    if dyna_groom.int_hair_number == bpy.context.object.particle_systems[idx_particle].settings.count \
                        and dyna_groom.int_hair_size == bpy.context.object.particle_systems[idx_particle].settings.hair_length \
                        and dyna_groom.int_hair_step == bpy.context.object.particle_systems[idx_particle].settings.hair_step \
                        and dyna_groom.int_hair_display_step == bpy.context.object.particle_systems[idx_particle].settings.display_step \
                        and dyna_groom.bool_hair_render_bspline == bpy.context.object.particle_systems[idx_particle].settings.use_hair_bspline \
                        and dyna_groom.int_hair_render_step == bpy.context.object.particle_systems[idx_particle].settings.render_step \
                        and dyna_groom.enum_children == bpy.context.object.particle_systems[idx_particle].settings.child_type \
                        and dyna_groom.int_children_display_amount == bpy.context.object.particle_systems[idx_particle].settings.child_nbr \
                        and dyna_groom.int_children_render_amount == bpy.context.object.particle_systems[idx_particle].settings.rendered_child_count \
                        and ( (bpy.context.scene.render.hair_type == 'STRAND' and dyna_groom.bool_hair_render_strand ==True ) \
                            or (bpy.context.scene.render.hair_type == 'STRIP' and dyna_groom.bool_hair_render_strip ==True ) ) \
                        and bpy.context.object.show_instancer_for_viewport == dyna_groom.bool_hair_show_emitter_viewport \
                        and bpy.context.object.show_instancer_for_render == dyna_groom.bool_hair_show_emitter_render:

                        if dyna_groom.bool_hair_opt:
                            row = layout.row().box()
                            row = row.column(align=True)
                            row_hair = row.column(align=True)
                            if not bpy.context.object.particle_systems[idx_particle].is_edited: #checa se particle foi editada
                                row_hair.enabled = True
                            else:
                                row_hair.enabled = False

                            if bpy.context.object.particle_systems[idx_particle].is_edited:
                                row_hair.label(text='Hair - CLEAR TO EDIT')
                            else:
                                row_hair.label(text='Hair')
                            row_hair.prop(dyna_groom,'int_hair_number',text='Amount of Hair')
                            row_hair.prop(dyna_groom,'int_hair_size',text='Size of Hair')
                            row_hair.prop(dyna_groom,'int_hair_step',text='Amount of Segments')
                            
                            row_hair_display = row.column(align=True)
                            row_hair_display.enabled = True
                            # if not context.mode != 'PARTICLE':
                            #     row_hair_display.enabled = True
                            # else:
                            #     row_hair_display.enabled = False

                            row_hair_display_col = row_hair_display.row()
                            row_hair_display_col.label(text='Display ')
                            row_hair_display_col.operator('hair.set_equal_display_segments',icon='SHADING_RENDERED')
                            row_hair_display_col_row = row_hair_display.row()
                            row_hair_display.prop(dyna_groom,'bool_hair_show_emitter_viewport',toggle=True)
                            row_hair_display_col_row.prop(dyna_groom,'int_hair_display_step',text='Display Segments')
                            
                            
                            row_hair_display.separator()
                            row_hair_display.separator()
                            row_hair_display.label(text='Render ')
                            row_hair_display.prop(dyna_groom,'bool_hair_show_emitter_render',toggle=True)
                            row_hair_display.prop(dyna_groom,'enum_hair_material',icon='MATERIAL')
                            # row_hair_display.separator()
                            row_hair_display.prop(dyna_groom,'bool_hair_render_bspline')
                            row_hair_display.prop(dyna_groom,'int_hair_render_step')

                            row_hair_display_col = row_hair_display.row(align=True)
                            row_hair_display_col.prop(dyna_groom,'bool_hair_render_strand',toggle=True,text='Strand')
                            row_hair_display_col.prop(dyna_groom,'bool_hair_render_strip',toggle=True,text='Strip')



                            ### particle edit options
                            # if context.mode == 'PARTICLE' and dyna_groom.bool_hair_part_mode_opt:
                            # if context.mode == 'PARTICLE':
                            row = layout.row().box()
                            row = row.column(align=True)
                            if context.mode == 'PARTICLE':
                                row.enabled = True
                            else:
                                row.enabled = False

                            if dyna_groom.bool_particle_edit_preserve_root == bpy.context.scene.tool_settings.particle_edit.use_preserve_root \
                                and dyna_groom.bool_particle_edit_preserve_length == bpy.context.scene.tool_settings.particle_edit.use_preserve_length:

                                row.prop(dyna_groom,'bool_particle_edit_preserve_root')
                                row.prop(dyna_groom,'bool_particle_edit_preserve_length')
                                col = row.row(align=True)
                                col.prop(dyna_groom,'int_rekey_number')
                                col.operator('hair.rekey')
                                row.operator('hair.unify_length')
                            else:
                                row_large = row.row()
                                row_large.scale_y = 2
                                row_large.operator('hair.updt_preserve_root_length')


                            row = layout.row().box()
                            if context.mode == 'PARTICLE':
                                row.enabled = True
                            else:
                                row.enabled = False
                            if dyna_groom.int_particle_edit_display_step == bpy.context.scene.tool_settings.particle_edit.display_step \
                                and dyna_groom.bool_particle_edit_show_children == bpy.context.scene.tool_settings.particle_edit.show_particles:
                                row.prop(dyna_groom,'int_particle_edit_display_step')
                                row.prop(dyna_groom,'bool_particle_edit_show_children')
                            else:
                                row_large = row.row()
                                row_large.scale_y = 2
                                row_large.operator('hair.updt_particle_display')
                            row = layout.row().box()
                            row.label(text='Set Weight')
                            row1 = row.row(align=True)

                            if context.mode == 'PARTICLE':
                                row.enabled = True
                            else:
                                row.enabled = False
                            row1.operator('hair.set_weight_0',text='0')
                            row1.operator('hair.set_weight_50',text='50')
                            row1.operator('hair.set_weight_100',text='100')
                            col = row.row()
                            col.prop(dyna_groom,'float_custom_weight')


                        if dyna_groom.bool_children_opt:
                            # row = layout.row().box()
                            # row.label(text='Children ')
                            row = layout.box().column(align=True)
                            
                            col = row.row()
                            post_col1 = col.row()
                            post_col1.label(text='Children ')
                            # post_col2 = col.row(align=True)

                            post_col3 = col.row(align=True,)
                            post_col3.prop(dyna_groom,'bool_check_point_local_hair_children',toggle=True)
                            post_col3.operator('hair.save_checkpoint_hair_children_preset',icon='COPYDOWN',text='')


                            # checa se tem algo para carregar no checkpoint
                            idx = context.active_object.hair_list_index
                            item = context.active_object.hair_list[idx]
                            part_sys_name = bpy.context.active_object.hair_list[idx].orig_name
                            # row.enabled = True if item.bool_lock_hair_layer else False
                            if item.bool_lock_hair_layer:
                                row.enabled = True
                                if bpy.context.active_object.modifiers[part_sys_name].show_viewport:
                                    row.enabled = True
                                else:
                                    row.enabled = False
                            else:
                                row.enabled = False


                            post_col3_enab_disab = post_col3.row(align=True)
                            
                            if dyna_groom.bool_check_point_local_hair_children:
                                if item.checkpoint_hair_children != '':
                                    post_col3_enab_disab.enabled = True
                                else:
                                    post_col3_enab_disab.enabled = False
                            else:
                                if dyna_groom.str_global_checkpoint_hair_children != '':
                                    post_col3_enab_disab.enabled = True
                                else:
                                    post_col3_enab_disab.enabled = False

                            post_col3_enab_disab.operator('hair.load_checkpoint_hair_children_preset',icon='PASTEDOWN',text='')
                            col = row.row(align=True)
                            col.prop(dyna_groom,'bool_children_none',toggle=True)
                            col.prop(dyna_groom,'bool_children_simple',toggle=True)
                            col.prop(dyna_groom,'bool_children_interpolated',toggle=True)
                            if dyna_groom.enum_children != 'NONE':
                                row = row.column(align=True)
                                row.prop(dyna_groom,'int_children_display_amount',text='Display amount')
                                row.prop(dyna_groom,'int_children_render_amount',text='Render Amount')
                                
                                row.prop(dyna_groom,'float_children_length',slider=True)
                                row.prop(dyna_groom,'float_children_threshold',slider=True)
                                row.prop(dyna_groom,'int_children_seed')
                                if dyna_groom.enum_children == 'INTERPOLATED':
                                    row.prop(dyna_groom,'float_children_virtual_parents',slider=True)
                                    row.prop(dyna_groom,'bool_children_long_hair')
                                elif dyna_groom.enum_children == 'SIMPLE':
                                    row.prop(dyna_groom,'float_children_size')
                                    row.prop(dyna_groom,'float_children_random_size')
                                    row.prop(dyna_groom,'float_children_radius')
                                    row.prop(dyna_groom,'float_children_roundness')
                                

                                row.separator()
                                row.separator()

                                col = row.row(align=True)

                                if dyna_groom.enum_children == 'INTERPOLATED':
                                    col.prop(dyna_groom,'bool_children_parting',toggle=True)
                                col.prop(dyna_groom,'bool_children_clumping',toggle=True)
                                col = row.row(align=True)
                                col.prop(dyna_groom,'bool_children_roughness',toggle=True)
                                col.prop(dyna_groom,'bool_children_kink',toggle=True)
                                row_warning = row.column(align=True)
                                
                                ### Show kink options
                                if dyna_groom.bool_children_kink:
                                    row.separator()
                                    col = row.row(align=True)
                                    col.prop(dyna_groom,'bool_children_kink_nothing',toggle=True)
                                    col.prop(dyna_groom,'bool_children_kink_curl',toggle=True)
                                    col = row.row(align=True)
                                    col.prop(dyna_groom,'bool_children_kink_radial',toggle=True)
                                    col.prop(dyna_groom,'bool_children_kink_wave',toggle=True)
                                    col = row.row(align=True)
                                    col.prop(dyna_groom,'bool_children_kink_braid',toggle=True)
                                    col.prop(dyna_groom,'bool_children_kink_spiral',toggle=True)

                                ### opcoes de parting clumping,roughness e kink
                                row.separator()
                                ### Parting (apenas para interpolation)
                                if dyna_groom.bool_children_parting:
                                    row_parting = row.column(align=True)
                                    if dyna_groom.float_children_virtual_parents == 0:
                                        row_parting.enabled = True
                                    else:
                                        layout_warning = row_warning
                                        text='Parting not available with virtual parents'
                                        _label_multiline(
                                            context=context,
                                            text=text,
                                            parent=layout_warning
                                        )
                                        
                                        row_parting.enabled = False
                                    row_parting.prop(dyna_groom,'float_children_parting_parting',slider=True)
                                    row_parting.prop(dyna_groom,'float_children_parting_min')
                                    row_parting.prop(dyna_groom,'float_children_parting_max')
                                #### Clumping
                                if dyna_groom.bool_children_clumping:
                                    row.prop(dyna_groom,'float_children_clump_clump',slider=True)
                                    row.prop(dyna_groom,'float_children_clump_shape',slider=True)
                                    row.prop(dyna_groom,'bool_children_clump_noise')
                                    row_noise = row.row()
                                    if dyna_groom.bool_children_clump_noise:
                                        row_noise.enabled = True
                                    else:
                                        row_noise.enabled = False
                                    row_noise.prop(dyna_groom,'float_children_clump_noise_size')
                                    if dyna_groom.enum_children == 'SIMPLE':
                                        row.prop(dyna_groom,'float_children_clump_twist')

                                ##### Roughness
                                if dyna_groom.bool_children_roughness:
                                    row.prop(dyna_groom,'float_children_roughness_uniform')
                                    row.prop(dyna_groom,'float_children_roughness_size')
                                    row.prop(dyna_groom,'float_children_roughness_endpoint')
                                    row.prop(dyna_groom,'float_children_roughness_shape')
                                    row.prop(dyna_groom,'float_children_roughness_random')
                                    row.prop(dyna_groom,'float_children_roughness_size2')
                                    row.prop(dyna_groom,'float_children_roughness_threshold')

                                #### Kink
                                # Options
                                if not dyna_groom.bool_children_kink_nothing and dyna_groom.bool_children_kink:
                                    row.prop(dyna_groom,'float_children_kink_amplitude')
                                    row.prop(dyna_groom,'float_children_kink_clump',slider=True)
                                    row.prop(dyna_groom,'float_children_kink_flatness')
                                    row.prop(dyna_groom,'float_children_kink_frequency')
                                    row.prop(dyna_groom,'float_children_kink_shape',slider=True)
                                    if dyna_groom.bool_children_kink_spiral:
                                        row.prop(dyna_groom,'float_children_kink_amplitude_random')
                                        row.prop(dyna_groom,'enum_children_kink_axis')
                                        row.prop(dyna_groom,'float_children_kink_axis_random')
                                        row.prop(dyna_groom,'int_children_kink_axis_steps')
                            row.separator()
                            col = row.row(align=True)
                            col.prop(dyna_groom,'bool_show_load_hair_children_panel',text='',icon='EXPORT',toggle=True)
                            col.prop(dyna_groom,'bool_show_save_hair_children_panel',text='',icon='IMPORT',toggle=True)
                            col.label(text='Load/Save Children')
                            if dyna_groom.bool_show_load_hair_children_panel:
                                row.prop(dyna_groom,'enum_hair_children_presets')
                                row.operator('hair.load_hair_children_preset')

                            if dyna_groom.bool_show_save_hair_children_panel:
                                row.prop(dyna_groom,'str_save_hair_children_preset_name')
                                row.operator('hair.save_hair_children_preset')

                        if dyna_groom.bool_hair_shape_opt:
                            row = layout.box().column(align=True)
                            col = row.row()
                            post_col1 = col.row()
                            post_col1.label(text='Hair Shape ')
                            # post_col2 = col.row(align=True)
                            
                            post_col3 = col.row(align=True,)
                            post_col3.prop(dyna_groom,'bool_check_point_local_hair_shape',toggle=True)
                            post_col3.operator('hair.save_checkpoint_hair_shape_preset',icon='COPYDOWN',text='')


                            # checa se tem algo para carregar no checkpoint
                            idx = context.active_object.hair_list_index
                            item = context.active_object.hair_list[idx]
                            part_sys_name = bpy.context.active_object.hair_list[idx].orig_name
                            # row.enabled = True if item.bool_lock_hair_layer else False
                            if item.bool_lock_hair_layer:
                                row.enabled = True
                                if bpy.context.active_object.modifiers[part_sys_name].show_viewport:
                                    row.enabled = True
                                else:
                                    row.enabled = False
                            else:
                                row.enabled = False




                            post_col3_enab_disab = post_col3.row(align=True)
                            # post_col3_enab_disab.enabled = True if item.checkpoint_hair_shape != '' else False
                            if dyna_groom.bool_check_point_local_hair_shape:
                                if item.checkpoint_hair_shape != '':
                                    post_col3_enab_disab.enabled = True
                                else:
                                    post_col3_enab_disab.enabled = False
                            else:
                                if dyna_groom.str_global_checkpoint_hair_shape != '':
                                    post_col3_enab_disab.enabled = True
                                else:
                                    post_col3_enab_disab.enabled = False

                            post_col3_enab_disab.operator('hair.load_checkpoint_hair_shape_preset',icon='PASTEDOWN',text='')
                            
                            row.prop(dyna_groom,'float_hair_strand_shape',slider=True)
                            row.prop(dyna_groom,'float_hair_strand_diameter_root')
                            row.prop(dyna_groom,'float_hair_strand_diameter_tip')
                            row.prop(dyna_groom,'float_hair_strand_diameter_scale')
                            row.prop(dyna_groom,'bool_hair_strand_close_tip')
                            row.separator()
                            col = row.row(align=True)
                            col.prop(dyna_groom,'bool_show_load_hair_shape_panel',text='',icon='EXPORT',toggle=True)
                            col.prop(dyna_groom,'bool_show_save_hair_shape_panel',text='',icon='IMPORT',toggle=True)
                            col.label(text='Load/Save Shape')
                            # row.operator('hair.save_hair_shape_preset')
                            if dyna_groom.bool_show_load_hair_shape_panel:
                                row.prop(dyna_groom,'enum_hair_shape_presets')
                                row.operator('hair.load_hair_shape_preset')

                            if dyna_groom.bool_show_save_hair_shape_panel:
                                row.prop(dyna_groom,'str_save_hair_shape_preset_name')
                                row.operator('hair.save_hair_shape_preset')
                

                        
                            
                    else:
                        row = layout.row().box()
                        row_large = row.row()
                        row_large.scale_y = 2
                        row_large.operator('hair.updt_panel_from_particles')
                        
            ###### Painel Main
            #########################################################

                #########################################################
                ###### Save
                if dyna_groom.bool_panel_save:
                        
                    row = layout.row().box()
                    row.label(text='Save Preset or Style: ') 
            
                    # row.label(text='Intri Calib')
                    # row = layout.row()
                    # row.label(text="Save")
                    row.prop(dyna_groom,'str_save_preset_name')
                    row.operator("hair.save_preset",icon='EXPORT')
                    # row.label(text="Save Style")
                    row.operator("hair.save_style",icon='EXPORT')
                ###### Save
                #########################################################

                #########################################################
                ###### Import / Export
                if dyna_groom.bool_panel_import:
            
                    row = layout.row().box()
                    row.label(text='Import/Export : ') 
                    # row.label(text='Intri Calib')
                    # row = layout.row()
                    # row.label(text="Save")

                    # row = layout.row().box()
                    # row.label(text="Import Preset or Style")
                    row.operator("hair.import_preset_or_style",icon='IMPORT')
                    # row.label(text="Export Preset or Style")
                    row.separator()
                if dyna_groom.bool_panel_export:
                    row = layout.row().box()
                    row.label(text='Export')
                    col = row.row(align=True)
                    col.prop(dyna_groom,'bool_export_hair_preset',text='Preset',toggle=True)
                    col.prop(dyna_groom,'bool_export_hair_style',text='Style',toggle=True)
                    col.prop(dyna_groom,'bool_export_hair_children',text='Child',toggle=True)
                    col.prop(dyna_groom,'bool_export_hair_shape',text='Shape',toggle=True)

                    row.prop(dyna_groom,'enum_preset_or_style_to_export',text='')
                    row.operator("hair.export_preset_or_style",icon='EXPORT')
                ###### Import / Export
                #########################################################

                #########################################################
                ###### Load
                if dyna_groom.bool_panel_load:
                        
                    row = layout.row().box()
                    row.label(text='Load : ') 
                    
                    
                    row.prop(dyna_groom,'enum_load_preset')
                    row.operator("hair.load_preset",icon='IMPORT')
                    # row.label(text="Load Preset")
                    row.separator()
                    row.separator()
                    row.prop(dyna_groom,'enum_load_preset_style')
                    row.label(text='This style uses '+str(dyna_groom.int_qty_saved_hair_style)+' Hairs')
                    row.operator("hair.load_style",icon='IMPORT')
                ###### Load
                #########################################################

                
                
                #########################################################
                ###### Edit Menu
                if dyna_groom.bool_panel_edit :
                

                    row = layout.row().box()
                    if context.mode == 'PARTICLE':
                        row.enabled = True
                    else:
                        row.enabled = False
                    # row.label(text='Edit & Selection Mode: ') 
                    row.label(text='Select Edit mode')
                    # row.operator("hair.mode_path")
                    row = row.column(align=True)
                    col = row.row(align=True)
                    col.prop(dyna_groom,'bool_editmode_path',text = "Path",icon = "PARTICLE_PATH",toggle=True)
                    # row.operator("hair.mode_point")
                    col.prop(dyna_groom,'bool_editmode_point', text = "Point",icon = "PARTICLE_POINT" ,toggle=True)
                    # row.operator("hair.mode_tip")
                    col.prop(dyna_groom,'bool_editmode_tip', text = "Tip",icon = "PARTICLE_TIP",toggle=True)

                    row.separator()
                    # row = layout.row().box()
                    row.label(text="Selction mode: Point")
                    row.operator("hair.unselect", icon="PANEL_CLOSE")
                    col = row.row(align=True)
                    col.operator("hair.select_root",text='Root', icon = "PIVOT_ACTIVE")
                    col.operator("hair.select_tip",text='Tip',icon = "PARTICLE_TIP")
                    row.operator("hair.select_root_and_next",text='R+',icon = "PIVOT_INDIVIDUAL")
                    col = row.row(align=True)
                    col.operator("hair.select_point_more",text='More', icon = "ADD")
                    col.operator("hair.select_point_less",text='Less', icon = "REMOVE")

                    row.operator("hair.invert_selection", icon="INDIRECT_ONLY_ON")

                ###### Edit Menu
                #########################################################


            #########################################################
            ###### Dynamics
            if dyna_groom.bool_panel_dynamic:
                row = layout.row().box()
                row.label(text='Dynamics')
                split0 = row.split(factor=0.25, align=True)
                col0_1 = split0.column( align=True)
                col0_2 = split0.column( align=True)
                col0_1.operator("hair.rewind",text='', icon = "REW")
                if bpy.context.screen.is_animation_playing:
                    col0_2.operator("hair.play_pause",text='', icon = "PAUSE")
                else:
                    col0_2.operator("hair.play_pause",text='', icon = "PLAY")
                # row.separator()
                split1 = row.split(factor=0.5, align=True)
                col1_1 = split1.column( align=True)
                col1_2 = split1.column( align=True)
                col1_1.operator("hair.add_dynamics",text='Add', icon = "PLUS")
                col1_2.operator("hair.apply_dynamics",text='Apply', icon = "CHECKMARK") 

                row.prop(dyna_groom,'bool_stop_loop',toggle=True)
                row.operator('hair.current_cache_to_bake')
                row.separator()
                row.operator('hair.delete_bakes')
                row.operator('hair.particle_edit_clear')
                row.separator()
                col0_3 = row.column( align=True)
                if bpy.context.screen.is_animation_playing:
                    col0_3.operator("hair.play_pause_style",text=' Style ', icon = "PAUSE")
                else:
                    col0_3.operator("hair.play_pause_style",text=' Style ', icon = "PLAY")
                # row.operator('hair.play_pause_style')
            ###### Dynamics
            #########################################################

            


        else:
            layout = self.layout
            text = 'Add an object to see the options'
            _label_multiline(
                context=context,
                text=text,
                parent=layout
            )
            
        #####################
        ### Testing cache manipulation
        # row = layout.row()
        # row.operator('hair.cache_manipulation_teste')
      
  
        return

    
from bpy.props import (StringProperty,
                       BoolProperty,
                      FloatProperty,
                      IntProperty,
                      StringProperty,
                      EnumProperty
                       )
from bpy.types import (PropertyGroup)

def updt_hair_opt(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_hair_opt:
        # dyna_groom.bool_hair_opt = False
        dyna_groom.bool_children_opt = False
        dyna_groom.bool_hair_shape_opt = False

def updt_children_opt(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_children_opt:
        dyna_groom.bool_hair_opt = False
        # dyna_groom.bool_children_opt = False
        dyna_groom.bool_hair_shape_opt = False

def updt_hair_shape_opt(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_hair_shape_opt:
        dyna_groom.bool_hair_opt = False
        dyna_groom.bool_children_opt = False
        # dyna_groom.bool_hair_shape_opt = False

def updt_vfxgrace_bool_3d_brush(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    bpy.context.scene.hair_brush_3d.use_3d_brush = self.vfxgrace_bool_3d_brush

def updt_vfxgrace_bool_auto_switch(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    bpy.context.scene.hair_brush_3d.auto_switch_mode = self.vfxgrace_bool_auto_switch

def updt_vfxgrace_bool_brush_scale(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    bpy.context.scene.hair_brush_3d.scale_size = self.vfxgrace_bool_brush_scale

def hair_section_callback(scene, context):
    dyna_groom = context.scene.dyna_groom_prop

    if bpy.context.active_object:

        if dyna_groom.str_json_sections == '':

            qtd_particles = len(bpy.context.active_object.particle_systems)

            hair_sections = []
            for c in range(qtd_particles):
                    hair_sections.append([c+1,'',''])
            # dyna_groom.str_json_sections = json.dumps(hair_sections)
        else:
            hair_sections = json.loads(dyna_groom.str_json_sections)
            qtd_particles = len(bpy.context.object.particle_systems)
            if  len(hair_sections) != qtd_particles:
                hair_sections = []
                for c in range(qtd_particles):
                        hair_sections.append([c+1,'',''])
                        # hair_sections.append([bpy.context.object.particle_systems[c].settings.name,'',''])
                # dyna_groom.str_json_sections = json.dumps(hair_sections)


        items = []


        ###Fix name on enum list , if the name is different on particle list
        if bpy.context.active_object:
            for i in range(len(hair_sections)):
                # if hair_sections[i][0] == int(id_to_update_name):
                ## update the name of the pie menus if name is different
                part_setting_name = bpy.context.active_object.particle_systems[i].settings.name
                if  part_setting_name != str(hair_sections[i][0])+'-'+hair_sections[i][1] and len(part_setting_name) >2 :
                    name_settings = bpy.context.active_object.particle_systems[i].settings.name
                    hair_sections[i][1] = name_settings[2:]

        # dyna_groom.str_json_sections = json.dumps(hair_sections)
        for h in hair_sections:
            
            items.append((str(h[0]),"%s" % str(h[0])+'-'+h[1],"Particle: %s" % str(h[0])+'-'+h[1]))
        if len(items) == 0:
            items.append((str(0),"Nothing","No Collection available"))
    else:
        items = []
    
    return items



def hair_vert_group_density_callback(scene, context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_density

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items

def hair_vert_group_length_callback(scene, context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_length

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items


def hair_vert_group_clump_callback(scene, context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_clump

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items


def hair_vert_group_kink_callback(scene, context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_kink

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items


def hair_vert_group_rough1_callback(scene, context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_1

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items


def hair_vert_group_rough2_callback(scene, context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_2

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items
def hair_vert_group_roughend_callback(scene, context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_end

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items


def hair_vert_group_twist_callback(scene, context):
    # dyna_groom = context.scene.dyna_groo   _curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    slcted_vert_group = bpy.context.object.particle_systems[idx_particle].vertex_group_twist

    items = []
    items.append(('-',"%s" % '',"Vertex Group: %s" % '-'))
    for vg in bpy.context.active_object.vertex_groups:
        items.append((vg.name,"%s" % vg.name,"Vertex Group: %s" % vg.name))
    return items

def hair_material_callback(scene, context):
    # dyna_groom = context.scene.dyna_groo   _curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    # slcted_mat = bpy.context.object.particle_systems[idx_particle].settings.material_slot

    items = []
    if len(bpy.context.active_object.material_slots) == 0:
        items.append(('Default Material',"%s" % 'Default Material',"Material: %s" % 'Default Material'))
    else:
        for mat in bpy.context.active_object.material_slots:
            items.append((mat.name,"%s" % mat.name,"Material: %s" % mat.name))
    return items


def hair_section_name(self,context):
    dyna_groom = context.scene.dyna_groom_prop

    hair_sections = json.loads(dyna_groom.str_json_sections)
    id_to_update_name = dyna_groom.enum_hair_curr_section
    name_section = dyna_groom.str_hair_sect_name

    for i in range(len(hair_sections)):
        if hair_sections[i][0] == int(id_to_update_name):
            hair_sections[i][1] = name_section
            ## update the name of the settings if name is different
            if  bpy.context.selected_objects[0].particle_systems[i].settings.name != str(hair_sections[i][0])+'-'+hair_sections[i][1] :
                bpy.context.selected_objects[0].particle_systems[i].settings.name = str(hair_sections[i][0])+'-'+hair_sections[i][1]

    dyna_groom.str_json_sections = json.dumps(hair_sections)


    # if selected_calib_prj != 'select':
    #         qty_cam = int(selected_calib_prj.split('CAM_')[0])
    
    #         easymocap_properties.easymocap_qty_cameras = qty_cam

    #         #create empty camera list
    #         cam_paths = []
    #         for c in range(qty_cam):
    #                 cam_paths.append([c,'',''])
            
    #         dyna_groom.str_json_sections = json.dumps(hair_sections)
                
def select_particle(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    # bpy.data.objects['Sphere'].particle_systems.active_index = int(id_to_update_name)
    bpy.context.active_object.particle_systems.active_index = idx_particle

    # if name of setting different, update in the pie menu
    # hair_sections = json.loads(dyna_groom.str_json_sections)
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    dyna_groom.enum_hair_vert_group_density = '-' #sempre tentar limpar as selecoes, pois o resultado que é realmente utilizado é vertez groups direto do particle system

    #marcar o valor do hair count number, quando trocar de particle, assim quando for alterar o valor ele ja fica com o valor correto
    dyna_groom.int_hair_number =  bpy.context.object.particle_systems[idx_particle].settings.count
    dyna_groom.int_hair_size =  bpy.context.object.particle_systems[idx_particle].settings.hair_length

    # name_section = dyna_groom.str_hair_sect_name

    # for i in range(len(hair_sections)):
    #     # if hair_sections[i][0] == int(id_to_update_name):
    #     ## update the name of the pie menus if name is different
    #     part_setting_name = bpy.context.selected_objects[0].particle_systems[i].settings.name
    #     if  part_setting_name != str(hair_sections[i][0])+'-'+hair_sections[i][1] and len(part_setting_name) >2 :
    #         name_settings = bpy.context.selected_objects[0].particle_systems[i].settings.name
    #         hair_sections[i][1] = name_settings[2:]

    # dyna_groom.str_json_sections = json.dumps(hair_sections)

def select_density_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_density
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_density = ""
    elif bpy.context.object.particle_systems[idx_particle].vertex_group_density != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_density = hair_vert_group
    
def select_length_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_length
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id


    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_length = ""
    elif  bpy.context.object.particle_systems[idx_particle].vertex_group_length != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_length = hair_vert_group

def select_clump_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_clump
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_clump = ""
    elif  bpy.context.object.particle_systems[idx_particle].vertex_group_clump != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_clump = hair_vert_group
def select_kink_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_kink
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_kink = ""
    elif  bpy.context.object.particle_systems[idx_particle].vertex_group_kink != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_kink = hair_vert_group
def select_rough1_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_rough1
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_1 = ""
    elif  bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_1 != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_1 = hair_vert_group
def select_rough2_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_rough2
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_2 = ""
    elif  bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_2 != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_2 = hair_vert_group
def select_roughend_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_roughend
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_end = ""
    elif  bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_end != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_roughness_end = hair_vert_group
def select_twist_vert_group(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_vert_group = dyna_groom.enum_hair_vert_group_twist
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if hair_vert_group =='-':
        bpy.context.object.particle_systems[idx_particle].vertex_group_twist = ""
    elif  bpy.context.object.particle_systems[idx_particle].vertex_group_twist != hair_vert_group:
        bpy.context.object.particle_systems[idx_particle].vertex_group_twist = hair_vert_group

def select_hair_material(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    hair_material = dyna_groom.enum_hair_material
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id

    if  bpy.context.object.particle_systems[idx_particle].settings.material_slot != hair_material:
        bpy.context.object.particle_systems[idx_particle].settings.material_slot = hair_material





def updt_list_name(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    #atualiza nomes para salvar presets
    dyna_groom.str_save_preset_name = self.name
    dyna_groom.str_save_hair_shape_preset_name = self.name
    dyna_groom.str_save_hair_children_preset_name = self.name

def updt_hair_number(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    # idx = context.active_object.hair_list_index
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    
    bpy.context.object.particle_systems[idx_particle].settings.count = self.int_hair_number
    
def updt_hair_size(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    
    bpy.context.object.particle_systems[idx_particle].settings.hair_length = self.int_hair_size

def updt_hair_step(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    
    bpy.context.object.particle_systems[idx_particle].settings.hair_step = self.int_hair_step

def updt_hair_display_step(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    
    bpy.context.object.particle_systems[idx_particle].settings.display_step = self.int_hair_display_step
    

def updt_hair_render_step(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    
    bpy.context.object.particle_systems[idx_particle].settings.render_step = self.int_hair_render_step

def updt_hair_render_bspline(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    
    bpy.context.object.particle_systems[idx_particle].settings.use_hair_bspline = self.bool_hair_render_bspline
 
def updt_hair_render_strand(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_hair_render_strand:
        dyna_groom.bool_hair_render_strip = False
        bpy.context.scene.render.hair_type = 'STRAND'
    
def updt_hair_render_strip(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_hair_render_strip:
        dyna_groom.bool_hair_render_strand = False
        bpy.context.scene.render.hair_type = 'STRIP'

def updt_hair_show_emitter_viewport(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_hair_show_emitter_viewport:
        bpy.context.object.show_instancer_for_viewport = True
    else:
        bpy.context.object.show_instancer_for_viewport = False
 
def updt_hair_show_emitter_render(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_hair_show_emitter_render:
        bpy.context.object.show_instancer_for_render = True
    else:
        bpy.context.object.show_instancer_for_render = False


#### Children
def updt_children_display_amount(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_nbr = self.int_children_display_amount
def updt_children_render_amount(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.rendered_child_count = self.int_children_render_amount
def updt_children_length(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_length = self.float_children_length
def updt_children_threshold(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_length_threshold = self.float_children_threshold
def updt_children_seed(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].child_seed = self.int_children_seed
def updt_children_virtual_parents(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.virtual_parents = self.float_children_virtual_parents
def updt_children_long_hair(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.create_long_hair_children = self.bool_children_long_hair


def updt_children_size(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_size = self.float_children_size
def updt_children_random_size(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_size_random = self.float_children_random_size
def updt_children_radius(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_radius = self.float_children_radius
def updt_children_roundness(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_roundness = self.float_children_roundness




### Parting
def updt_children_parting_parting(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_parting_factor = self.float_children_parting_parting
def updt_children_parting_min(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_parting_min = self.float_children_parting_min
def updt_children_parting_max(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.child_parting_max = self.float_children_parting_max

### Clumping
def updt_children_clump_clump(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.clump_factor = self.float_children_clump_clump
def updt_children_clump_shape(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.clump_shape = self.float_children_clump_shape
def updt_children_clump_noise(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.use_clump_noise = self.bool_children_clump_noise
def updt_children_clump_noise_size(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.clump_noise_size = self.float_children_clump_noise_size
def updt_children_clump_twist(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.twist = self.float_children_clump_twist


######### Roughness
def updt_children_roughness_uniform(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.roughness_1 = self.float_children_roughness_uniform
####
def updt_children_roughness_size(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.roughness_1_size = self.float_children_roughness_size
def updt_children_roughness_endpoint(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.roughness_endpoint = self.float_children_roughness_endpoint
def updt_children_roughness_shape(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.roughness_end_shape = self.float_children_roughness_shape
def updt_children_roughness_random(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.roughness_2 = self.float_children_roughness_random
def updt_children_roughness_size2(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.roughness_2_size = self.float_children_roughness_size2
def updt_children_roughness_threshold(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.roughness_2_threshold = self.float_children_roughness_threshold

########## Kink
def updt_children_kink_nothing(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_kink_nothing:
        bpy.context.object.particle_systems[idx_particle].settings.kink = 'NO'
        # dyna_groom.bool_children_kink_nothing = False
        dyna_groom.bool_children_kink_curl = False
        dyna_groom.bool_children_kink_radial = False
        dyna_groom.bool_children_kink_wave = False
        dyna_groom.bool_children_kink_braid = False
        dyna_groom.bool_children_kink_spiral = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.kink == 'NO' and not dyna_groom.bool_children_kink_nothing :
        dyna_groom.bool_children_kink_nothing = True
def updt_children_kink_curl(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_kink_curl:
        bpy.context.object.particle_systems[idx_particle].settings.kink = 'CURL'
        dyna_groom.bool_children_kink_nothing = False
        # dyna_groom.bool_children_kink_curl = False
        dyna_groom.bool_children_kink_radial = False
        dyna_groom.bool_children_kink_wave = False
        dyna_groom.bool_children_kink_braid = False
        dyna_groom.bool_children_kink_spiral = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.kink == 'CURL' and not dyna_groom.bool_children_kink_curl :
        dyna_groom.bool_children_kink_curl = True
def updt_children_kink_radial(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_kink_radial:
        bpy.context.object.particle_systems[idx_particle].settings.kink = 'RADIAL'
        dyna_groom.bool_children_kink_nothing = False
        dyna_groom.bool_children_kink_curl = False
        # dyna_groom.bool_children_kink_radial = False
        dyna_groom.bool_children_kink_wave = False
        dyna_groom.bool_children_kink_braid = False
        dyna_groom.bool_children_kink_spiral = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.kink == 'RADIAL' and not dyna_groom.bool_children_kink_radial :
        dyna_groom.bool_children_kink_radial = True
def updt_children_kink_wave(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_kink_wave:
        bpy.context.object.particle_systems[idx_particle].settings.kink = 'WAVE'
        dyna_groom.bool_children_kink_nothing = False
        dyna_groom.bool_children_kink_curl = False
        dyna_groom.bool_children_kink_radial = False
        # dyna_groom.bool_children_kink_wave = False
        dyna_groom.bool_children_kink_braid = False
        dyna_groom.bool_children_kink_spiral = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.kink == 'WAVE' and not dyna_groom.bool_children_kink_wave :
        dyna_groom.bool_children_kink_wave = True
def updt_children_kink_braid(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_kink_braid:
        bpy.context.object.particle_systems[idx_particle].settings.kink = 'BRAID'
        dyna_groom.bool_children_kink_nothing = False
        dyna_groom.bool_children_kink_curl = False
        dyna_groom.bool_children_kink_radial = False
        dyna_groom.bool_children_kink_wave = False
        # dyna_groom.bool_children_kink_braid = False
        dyna_groom.bool_children_kink_spiral = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.kink == 'BRAID' and not dyna_groom.bool_children_kink_braid :
        dyna_groom.bool_children_kink_braid = True
def updt_children_kink_spiral(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_kink_spiral:
        bpy.context.object.particle_systems[idx_particle].settings.kink = 'SPIRAL'
        dyna_groom.bool_children_kink_nothing = False
        dyna_groom.bool_children_kink_curl = False
        dyna_groom.bool_children_kink_radial = False
        dyna_groom.bool_children_kink_wave = False
        dyna_groom.bool_children_kink_braid = False
        # dyna_groom.bool_children_kink_spiral = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.kink == 'SPIRAL' and not dyna_groom.bool_children_kink_spiral :
        dyna_groom.bool_children_kink_spiral = True


#### Kink Options
def updt_children_kink_amplitude(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_amplitude = self.float_children_kink_amplitude
def updt_children_kink_clump(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_amplitude_clump = self.float_children_kink_clump
def updt_children_kink_flatness(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_flat = self.float_children_kink_flatness
def updt_children_kink_frequency(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_frequency = self.float_children_kink_frequency
def updt_children_kink_shape(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_shape = self.float_children_kink_shape
#### Kink spiral options
def updt_children_kink_amplitude_random(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_amplitude_random = self.float_children_kink_amplitude_random
def updt_enum_children_kink_axis(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_axis = self.enum_children_kink_axis
def updt_children_kink_axis_random(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_axis_random = self.float_children_kink_axis_random
def updt_children_kink_axis_steps(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.kink_extra_steps = self.int_children_kink_axis_steps

def updt_show_save_hair_children_panel(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if dyna_groom.bool_show_save_hair_children_panel:
        dyna_groom.bool_show_load_hair_children_panel = False

def updt_show_load_hair_children_panel(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if dyna_groom.bool_show_load_hair_children_panel:
        dyna_groom.bool_show_save_hair_children_panel = False


##### Hair Shape
def updt_hair_strand_shape(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.shape = self.float_hair_strand_shape
def updt_hair_strand_diameter_root(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.root_radius = self.float_hair_strand_diameter_root
def updt_hair_strand_diameter_tip(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.tip_radius = self.float_hair_strand_diameter_tip
def updt_hair_strand_diameter_scale(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.radius_scale = self.float_hair_strand_diameter_scale
def updt_hair_strand_close_tip(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    bpy.context.object.particle_systems[idx_particle].settings.use_close_tip = self.bool_hair_strand_close_tip

def updt_show_save_hair_shape_panel(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if dyna_groom.bool_show_save_hair_shape_panel:
        dyna_groom.bool_show_load_hair_shape_panel = False

def updt_show_load_hair_shape_panel(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if dyna_groom.bool_show_load_hair_shape_panel:
        dyna_groom.bool_show_save_hair_shape_panel = False



def updt_enum_children(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    
    bpy.context.object.particle_systems[idx_particle].settings.child_type = self.enum_children

def updt_particle_edit_display_step(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    
    bpy.context.scene.tool_settings.particle_edit.display_step = self.int_particle_edit_display_step

def updt_particle_edit_show_children(self,context):
    # dyna_groom = context.scene.dyna_groom_prop
    # id_to_update_name = dyna_groom.enum_hair_curr_section
    
    bpy.context.scene.tool_settings.particle_edit.show_particles = self.bool_particle_edit_show_children

def updt_custom_weight(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    custom_weight = dyna_groom.float_custom_weight

    bpy.context.scene.tool_settings.particle_edit.brush.strength = custom_weight
    bpy.ops.particle.weight_set(factor=1)
    
def updt_particle_edit_preserve_root(self,context):
    bpy.context.scene.tool_settings.particle_edit.use_preserve_root = self.bool_particle_edit_preserve_root

def updt_particle_edit_preserve_length(self,context):
    bpy.context.scene.tool_settings.particle_edit.use_preserve_length = self.bool_particle_edit_preserve_length




def updt_bool_panel_main(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_panel_main:
        dyna_groom.bool_panel_save = False
        dyna_groom.bool_panel_edit = False
        dyna_groom.bool_panel_load = False
        dyna_groom.bool_panel_import_export = False
        dyna_groom.bool_panel_dynamic = False

def updt_bool_panel_dynamic(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_panel_dynamic:
        dyna_groom.bool_panel_save = False
        dyna_groom.bool_panel_edit = False
        dyna_groom.bool_panel_load = False
        dyna_groom.bool_panel_import_export = False
        dyna_groom.bool_panel_main = False

def updt_bool_panel_edit(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_panel_edit:
        dyna_groom.bool_panel_main = False
        dyna_groom.bool_panel_save = False
        dyna_groom.bool_panel_load = False
        dyna_groom.bool_panel_import_export = False
        dyna_groom.bool_panel_dynamic = False
def updt_bool_panel_save(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_panel_save:
        dyna_groom.bool_panel_main = False
        dyna_groom.bool_panel_edit = False
        dyna_groom.bool_panel_load = False
        dyna_groom.bool_panel_import_export = False
        dyna_groom.bool_panel_dynamic = False
def updt_bool_panel_import(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_panel_import:
        # dyna_groom.bool_panel_import = False
        dyna_groom.bool_panel_export = False
        dyna_groom.bool_panel_main = False
        dyna_groom.bool_panel_edit = False
        dyna_groom.bool_panel_load = False
        dyna_groom.bool_panel_save = False
        dyna_groom.bool_panel_dynamic = False
def updt_bool_panel_export(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_panel_export:
        dyna_groom.bool_panel_import = False
        # dyna_groom.bool_panel_export = False
        dyna_groom.bool_panel_main = False
        dyna_groom.bool_panel_edit = False
        dyna_groom.bool_panel_load = False
        dyna_groom.bool_panel_save = False
        dyna_groom.bool_panel_dynamic = False

def updt_bool_panel_load(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_panel_load:
        dyna_groom.bool_panel_main = False
        dyna_groom.bool_panel_edit = False
        dyna_groom.bool_panel_save = False
        dyna_groom.bool_panel_import_export = False
        dyna_groom.bool_panel_dynamic = False


def updt_bool_export_hair_preset(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_export_hair_preset:
        # dyna_groom.bool_export_hair_preset = False
        dyna_groom.bool_export_hair_style = False
        dyna_groom.bool_export_hair_children = False
        dyna_groom.bool_export_hair_shape = False
        
def updt_bool_export_hair_style(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_export_hair_style:
        dyna_groom.bool_export_hair_preset = False
        # dyna_groom.bool_export_hair_style = False
        dyna_groom.bool_export_hair_children = False
        dyna_groom.bool_export_hair_shape = False
def updt_bool_export_hair_children(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_export_hair_children:
        dyna_groom.bool_export_hair_preset = False
        dyna_groom.bool_export_hair_style = False
        # dyna_groom.bool_export_hair_children = False
        dyna_groom.bool_export_hair_shape = False
def updt_bool_export_hair_shape(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    if self.bool_export_hair_shape:
        dyna_groom.bool_export_hair_preset = False
        dyna_groom.bool_export_hair_style = False
        dyna_groom.bool_export_hair_children = False
        # dyna_groom.bool_export_hair_shape = False

def updt_bool_editmode_path(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_editmode_path:
        bpy.context.scene.tool_settings.particle_edit.select_mode = 'PATH'
        dyna_groom.bool_editmode_point = False
        dyna_groom.bool_editmode_tip = False
    elif bpy.context.scene.tool_settings.particle_edit.select_mode == 'PATH' and not dyna_groom.bool_editmode_path :
        dyna_groom.bool_editmode_path = True
    
def updt_bool_editmode_point(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_editmode_point:
        bpy.context.scene.tool_settings.particle_edit.select_mode = 'POINT'
        dyna_groom.bool_editmode_path = False
        dyna_groom.bool_editmode_tip = False
    elif bpy.context.scene.tool_settings.particle_edit.select_mode == 'POINT' and not dyna_groom.bool_editmode_point :
        dyna_groom.bool_editmode_point = True

def updt_bool_editmode_tip(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_editmode_tip:
        bpy.context.scene.tool_settings.particle_edit.select_mode = 'TIP'
        dyna_groom.bool_editmode_path = False
        dyna_groom.bool_editmode_point = False
    elif bpy.context.scene.tool_settings.particle_edit.select_mode == 'TIP' and not dyna_groom.bool_editmode_tip :
        dyna_groom.bool_editmode_tip = True

def updt_bool_children_none(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_none:
        bpy.context.object.particle_systems[idx_particle].settings.child_type = 'NONE'
        dyna_groom.bool_children_simple = False
        dyna_groom.bool_children_interpolated = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.child_type == 'NONE' and not dyna_groom.bool_children_none :
        dyna_groom.bool_children_none = True
def updt_bool_children_simple(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_simple:
        bpy.context.object.particle_systems[idx_particle].settings.child_type = 'SIMPLE'
        dyna_groom.bool_children_none = False
        dyna_groom.bool_children_interpolated = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.child_type == 'SIMPLE' and not dyna_groom.bool_children_simple :
        dyna_groom.bool_children_simple = True
def updt_bool_children_interpolated(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    if dyna_groom.bool_children_interpolated:
        bpy.context.object.particle_systems[idx_particle].settings.child_type = 'INTERPOLATED'
        dyna_groom.bool_children_none = False
        dyna_groom.bool_children_simple = False
        update_hair_values_on_panel(context,0)
    elif bpy.context.object.particle_systems[idx_particle].settings.child_type == 'INTERPOLATED' and not dyna_groom.bool_children_interpolated :
        dyna_groom.bool_children_interpolated = True

def updt_bool_children_parting(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_children_parting:
        dyna_groom.bool_children_clumping = False
        dyna_groom.bool_children_roughness = False
        dyna_groom.bool_children_kink = False
        update_hair_values_on_panel(context,0)
def updt_bool_children_clumping(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_children_clumping:
        dyna_groom.bool_children_parting = False
        dyna_groom.bool_children_roughness = False
        dyna_groom.bool_children_kink = False
        update_hair_values_on_panel(context,0)
def updt_bool_children_roughness(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_children_roughness:
        dyna_groom.bool_children_clumping = False
        dyna_groom.bool_children_parting = False
        dyna_groom.bool_children_kink = False
        update_hair_values_on_panel(context,0)
def updt_bool_children_kink(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_children_kink:
        dyna_groom.bool_children_clumping = False
        dyna_groom.bool_children_roughness = False
        dyna_groom.bool_children_parting = False
        update_hair_values_on_panel(context,0)

def enum_qty_style(self,context):
    dyna_groom = context.scene.dyna_groom_prop
    folder_path = os.path.dirname(os.path.realpath(__file__))
    name_preset_load = self.enum_load_preset_style.replace('.json','')
    preset_file = os.path.join(folder_path, 'presets', name_preset_load+'.json')

    import json
    with open(preset_file) as json_file:
        data = json.load(json_file)

    dyna_groom.int_qty_saved_hair_style = len(data)
    
    

def preset_files_callback(scene, context):

    import glob, os
    directory = os.path.join(os.path.dirname(__file__), "presets")

    files = []
    os.chdir(directory)
    for file in glob.glob("PRESET_*.json"):
        # print(file)
        files.append(file)
   
    # print(list_folder)
    
    items = []
    ####
    #generate the custom size to search for Constraint name (to be able to use "startswith")
    # len_name_start_ctr = len(name+'-{:03}'.format(0))

    for x in files:
        
        items.append((x,"%s" % x,"Preset: %s" % x))
    if len(files) == 0:
        items.append(('-',"Nothing","No Preset available"))

    return items

def preset_style_files_callback(scene, context):

    import glob, os
    directory = os.path.join(os.path.dirname(__file__), "presets")

    files = []
    os.chdir(directory)
    for file in glob.glob("STYLE_*.json"):
        # print(file)
        files.append(file)
   
    # print(list_folder)
    
    items = []
    ####
    #generate the custom size to search for Constraint name (to be able to use "startswith")
    # len_name_start_ctr = len(name+'-{:03}'.format(0))

    for x in files:
        
        items.append((x,"%s" % x,"Preset: %s" % x))
    if len(files) == 0:
        items.append(('-',"Nothing","No Preset available"))

    return items

def preset_hair_shape_files_callback(scene, context):

    import glob, os
    directory = os.path.join(os.path.dirname(__file__), 'presets')

    files = []
    os.chdir(directory)
    for file in glob.glob("SHAPE_*.json"):
        files.append(file)
   
    items = []
    ####
    #generate the custom size to search for Constraint name (to be able to use "startswith")
    # len_name_start_ctr = len(name+'-{:03}'.format(0))

    for x in files:
        
        items.append((x,"%s" % x,"Preset: %s" % x))
    if len(files) == 0:
        items.append(('-',"Nothing","No Preset available"))

    return items

def preset_hair_children_files_callback(scene, context):

    import glob, os
    directory = os.path.join(os.path.dirname(__file__), 'presets',)

    files = []
    os.chdir(directory)
    for file in glob.glob("CHILD_*.json"):
        files.append(file)
   
    items = []
    ####
    #generate the custom size to search for Constraint name (to be able to use "startswith")
    # len_name_start_ctr = len(name+'-{:03}'.format(0))

    for x in files:
        
        items.append((x,"%s" % x,"Preset: %s" % x))
    if len(files) == 0:
        items.append(('-',"Nothing","No Preset available"))

    return items



def preset_generic_files_callback(scene, context):

    import glob, os
    from collections import OrderedDict
    directory = os.path.join(os.path.dirname(__file__), "presets")

    files = []
    os.chdir(directory)
    for file in glob.glob("*.json"):
        # print(file)
        file.replace('_preset.json','').replace('_style.json','')
        # files.append(file)
        files.append(file.replace('_preset.json','').replace('_style.json',''))
    
    files = list(OrderedDict.fromkeys(files)) #remove duplicate
   
    # print(list_folder)
    
    items = []
    ####
    #generate the custom size to search for Constraint name (to be able to use "startswith")
    # len_name_start_ctr = len(name+'-{:03}'.format(0))

    for x in files:
        
        items.append((x,"%s" % x,"Preset: %s" % x))
    if len(files) == 0:
        items.append(('-',"Nothing","No Preset available"))

    return items


def preset_or_style_files_callback(scene, context):
    dyna_groom = context.scene.dyna_groom_prop

    import glob, os
    directory = os.path.join(os.path.dirname(__file__), "presets")

    #escolhendo os arquivos a mostrar para exportar
    if dyna_groom.bool_export_hair_preset:
        glob_file_search = 'PRESET_*.json'
    elif dyna_groom.bool_export_hair_style:
        glob_file_search = 'STYLE_*.json'
    elif dyna_groom.bool_export_hair_children:
        glob_file_search = 'CHILD_*.json'
    elif dyna_groom.bool_export_hair_shape:
        glob_file_search = 'SHAPE_*.json'
    else:
        glob_file_search = '*.json'

    files = []
    os.chdir(directory)
    for file in glob.glob(glob_file_search):
        # print(file)
        files.append(file)
   
    # print(list_folder)
    
    items = []
    ####
    #generate the custom size to search for Constraint name (to be able to use "startswith")
    # len_name_start_ctr = len(name+'-{:03}'.format(0))

    for x in files:
        
        items.append((x,"%s" % x,"Preset: %s" % x))
    if len(files) == 0:
        items.append(('-',"Nothing","No Preset available"))

    return items

       
def updt_shapekey_influence(self,context): #primeira versao, so leva em consideracao a ultima transformacao e a atual

    idx = context.active_object.hair_list_index
    idx_particle = context.active_object.hair_list[idx].particle_system_id
    hair_settings = context.object.particle_systems[idx_particle].settings
    hair_list_shapekey = hair_settings.particle_shape
    hair_list_shapekey_index = hair_settings.particle_shape_index
    # hair_list_shapekey_index = self.particle_shape_index

    if len(hair_list_shapekey) > 0 :
        bpy.ops.object.mode_set(mode='OBJECT')
        load_last_shape = json.loads(bpy.context.object.particle_systems[idx_particle].settings.particle_last_shape)
        load_hairs = json.loads(bpy.context.object.particle_systems[idx_particle].settings.particle_shape[hair_list_shapekey_index].partic_data)

        deps_graph = bpy.context.evaluated_depsgraph_get()
        evaluated_object = bpy.context.object.evaluated_get(deps_graph)
        particle_system = evaluated_object.particle_systems.active


        for p,base,hair in zip(particle_system.particles,load_last_shape,load_hairs):
            for v,b,h in zip(p.hair_keys,base,hair):

                # v.co[0] = h[0]
                # v.co[1] = h[1]
                # v.co[2] = h[2]

                # v.co[0] = b[0]+((b[0] - h[0]) * self.partic_shapekey_influence)
                # v.co[1] = b[1]+((b[1] - h[1]) * self.partic_shapekey_influence)
                # v.co[2] = b[2]+((b[2] - h[2]) * self.partic_shapekey_influence)

                v.co[0] = b[0]+((h[0] - b[0]) * self.partic_shapekey_influence)
                v.co[1] = b[1]+((h[1] - b[1]) * self.partic_shapekey_influence)
                v.co[2] = b[2]+((h[2] - b[2]) * self.partic_shapekey_influence)

        bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
        bpy.ops.object.mode_set(mode='OBJECT')


def updt_shapekey_influence_full_stack(self,context):
    dyna_groom = bpy.context.scene.dyna_groom_prop
    if dyna_groom.bool_enable_shapekey:
        idx = context.active_object.hair_list_index
        idx_particle = context.active_object.hair_list[idx].particle_system_id
        hair_settings = context.active_object.particle_systems[idx_particle].settings
        hair_list_shapekey = hair_settings.particle_shape
        hair_list_shapekey_index = hair_settings.particle_shape_index



        load_base = json.loads(hair_list_shapekey[0].partic_data)
        for i_ps,ps in enumerate(hair_list_shapekey):
            # print (i_ps,' - ',ps.partic_name)
            # if i_ps ==1: #guada a informacao da base shapekey
            #     load_last = load_base
            if i_ps >= 1: #no i_ps =1 o last é  load_base, por isso o post_influence esta vazio
                if i_ps == 1:
                    load_last = load_base
                else:
                    load_last = json.loads(hair_settings.particle_shape[i_ps-1].partic_data_post_influence)
                    # load_last = json.loads(hair_settings.particle_last_shape)
                #carrega dado atual
                load_hair = json.loads(ps.partic_data)
                influence = ps.partic_shapekey_influence

                bpy.ops.object.mode_set(mode='OBJECT')
                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active

                precision = 4
                precision_string = "{:."+str(precision)+"f}" #ajuste necessario pois, apesar de nao mover alguns pontos, propositalmente, eles acabam sendo movimentados, e isso bagunca o funcionamento

                # for p,base,l_last,hair in zip(particle_system.particles,load_base,load_last,load_hair): #fios de cabelo
                for i_h,hair_strand in enumerate(zip(particle_system.particles,load_base,load_last,load_hair)): #fios de cabelo
                    p = hair_strand[0]
                    base = hair_strand[1]
                    l_last = hair_strand[2]
                    hair = hair_strand[3]
                    # for v,b,ll,h in zip(p.hair_keys,base,l_last,hair): #ponto dos fios de cabelo "keys"
                    for i_h_key,hair_keys in enumerate(zip(p.hair_keys,base,l_last,hair)): #ponto dos fios de cabelo "keys"
                        v = hair_keys[0]
                        b = hair_keys[1]
                        ll = hair_keys[2]
                        h = hair_keys[3]
                        # print(i_h,'-',i_h_key)
                        # if b[0] != h[0]:
                        # if "{:.4f}".format(b[0]) != "{:.4f}".format(h[0]) :
                        if precision_string.format(b[0]) != precision_string.format(h[0]) :
                            v.co[0] = ll[0]+((h[0] - ll[0]) * influence)
                        else:
                            v.co[0] = ll[0]
                        # if b[1] != h[1]:
                        # if "{:.4f}".format(b[1]) != "{:.4f}".format(h[1]) :
                        if precision_string.format(b[1]) != precision_string.format(h[1]) :
                            v.co[1] = ll[1]+((h[1] - ll[1]) * influence)
                        else:
                            v.co[1] = ll[1]
                        # if b[2] != h[2]:
                        # if "{:.4f}".format(b[2]) != "{:.4f}".format(h[2]) :
                        if precision_string.format(b[2]) != precision_string.format(h[2]) :
                                v.co[2] = ll[2]+((h[2] - ll[2]) * influence)
                        else:
                            v.co[2] = ll[2]

                #ao terminar de rodar todos os fios de cabelo
                bpy.ops.object.mode_set(mode='PARTICLE_EDIT')
                bpy.ops.object.mode_set(mode='OBJECT') #fixar os valores

                    # Apos processar, guardar a nva forma na propriedade particle_last_shape


                deps_graph = bpy.context.evaluated_depsgraph_get()
                evaluated_object = bpy.context.object.evaluated_get(deps_graph)
                particle_system = evaluated_object.particle_systems.active
                
                hairs = []

                for p in particle_system.particles:
                    hair = []
                    for v in p.hair_keys:
                        hair.append([v.co[0], v.co[1], v.co[2]])
                    hairs.append(hair)

                hairs____ = hairs
                
                save_hairs = json.dumps(hairs)
                # hair_settings.particle_last_shape = save_hairs
                ps.partic_data_post_influence = save_hairs


class DynaGroomSettings(PropertyGroup):
    int_hair_sections : IntProperty(default=1, name="Amount of Sections",min=1,max=9)
    # bool_edit_hair_sections : BoolProperty(default=True, name="Enable hair section editing")
    enum_hair_curr_section : EnumProperty(
        name="Hair Section",
        description="Select Hair Section.",
        items=hair_section_callback,
        update=select_particle
        )
    enum_hair_vert_group_density : EnumProperty(
        name="Density Vertex Group",
        description="Vertex Group for Density Control.",
        items=hair_vert_group_density_callback,
        update=select_density_vert_group
        )

    enum_hair_vert_group_length : EnumProperty(
        name="Length Vertex Group",
        description="Vertex Group for Length Control.",
        items=hair_vert_group_length_callback,
        update=select_length_vert_group
        )
    enum_hair_vert_group_clump : EnumProperty(
        name="Clump Vertex Group",
        description="Vertex Group for Clump Control.",
        items=hair_vert_group_clump_callback,
        update=select_clump_vert_group
        )
    enum_hair_vert_group_kink : EnumProperty(
        name="Kink Vertex Group",
        description="Vertex Group for Kink Control.",
        items=hair_vert_group_kink_callback,
        update=select_kink_vert_group
        )
    enum_hair_vert_group_rough1 : EnumProperty(
        name="Roughness1 Vertex Group",
        description="Vertex Group for Roughness1 Control.",
        items=hair_vert_group_rough1_callback,
        update=select_rough1_vert_group
        )
    enum_hair_vert_group_rough2 : EnumProperty(
        name="Roughness2 Vertex Group",
        description="Vertex Group for Roughness2 Control.",
        items=hair_vert_group_rough2_callback,
        update=select_rough2_vert_group
        )
    enum_hair_vert_group_roughend : EnumProperty(
        name="Roughness End Vertex Group",
        description="Vertex Group for Roughness End Control.",
        items=hair_vert_group_roughend_callback,
        update=select_roughend_vert_group
        )
    enum_hair_vert_group_twist : EnumProperty(
        name="Twist Vertex Group",
        description="Vertex Group for Twist Control.",
        items=hair_vert_group_twist_callback,
        update=select_twist_vert_group
        )
    
    enum_hair_material : EnumProperty(
        name="Material",
        description="Hair Material",
        items=hair_material_callback,
        update=select_hair_material
        )

    str_hair_sect_name : StringProperty(default='', name="Name of Section",update=hair_section_name)
    str_json_sections: StringProperty(name="Json dump with all the sections", description="Json dump with all the sections")

    int_hair_number : IntProperty(default=1000, name="Amount of Hair Particles",min=0,update=updt_hair_number)
    int_hair_size : FloatProperty(default=4.0, name="Size of Hair Particles",min=0.0,update=updt_hair_size)
    int_hair_step : IntProperty(default=5, name="Amount of Hair Segments",min=2,update=updt_hair_step)

    int_hair_display_step : IntProperty(default=5, name="Amount of Hair Display Segments",min=0,max=10,update=updt_hair_display_step)
    bool_hair_show_emitter_viewport : BoolProperty(default=True,name= "Show Emitter Viewport",update=updt_hair_show_emitter_viewport)
    bool_hair_show_emitter_render : BoolProperty(default=True,name= "Show Emitter Render",update=updt_hair_show_emitter_render)
    bool_hair_render_strand : BoolProperty(default=True,name= "Render hair strand",update=updt_hair_render_strand)
    bool_hair_render_strip : BoolProperty(default=False,name= "Render hair strip",update=updt_hair_render_strip)
    int_hair_render_step : IntProperty(default=2, name="Amount of Hair Render Segments",min=0,max=9,update=updt_hair_render_step)
    bool_hair_render_bspline : BoolProperty(default=False,name= "Interporlate hair using Bspline",update=updt_hair_render_bspline)

    enum_children : EnumProperty(
        name="Type of children",
        description="Type of Children",
        items={
            ('NONE','None','None'),
            ('SIMPLE','Simple','Simple'),
            ('INTERPOLATED','Interpolated','Interpolated'),
        },
         update=updt_enum_children
        )

    
    

    str_save_preset_name: StringProperty(name="Name To save preset", description="Name to save preset")
    enum_load_preset : EnumProperty(
        name="Preset to load",
        description="Choose a preset to load",
        items=preset_files_callback,
        # update=select_density_vert_group
        )
    enum_load_preset_style : EnumProperty(
        name="Preset to load style",
        description="Choose a preset to load style",
        items=preset_style_files_callback,
        update=enum_qty_style
        )
    int_qty_saved_hair_style: IntProperty(name="Amount of hair saved in the file of the Style", default=0)
    enum_preset_or_style_to_export : EnumProperty(
        name="Preset or Style to Export",
        description="Choose a Preset or Styleto Export",
        items=preset_or_style_files_callback,
        # update=select_density_vert_group
        )
    
    # enum_load_preset_generic : EnumProperty(
    #     name="Preset to load",
    #     description="Choose a preset oe style to load",
    #     items=preset_generic_files_callback,
    #     # update=select_density_vert_group
    #     )
    int_particle_edit_display_step: IntProperty(name="Quality of hair in particle Edit mode", default=2,min=1,max=10,update=updt_particle_edit_display_step)
    bool_particle_edit_show_children: BoolProperty(name="Show Children Particles", default=False,update=updt_particle_edit_show_children)

    float_custom_weight: FloatProperty(name="Custom Weight", default=0.5,min=0.001,max=1.0,update=updt_custom_weight)
    bool_particle_edit_preserve_root:BoolProperty(name="Preserve Root Location", default=True,update=updt_particle_edit_preserve_root)
    bool_particle_edit_preserve_length:BoolProperty(name="Preserve Length", default=True,update=updt_particle_edit_preserve_length)

    bool_panel_dynamic : BoolProperty(name='Dynamic Panel',description="Show dynamic panel", default=False,update=updt_bool_panel_dynamic)
    bool_panel_hair_layer : BoolProperty(name='Hair Layer',description="Show Hair layer control", default=True)
    bool_panel_main : BoolProperty(name='Main',description="Main Panel", default=True, update=updt_bool_panel_main)
    bool_panel_edit : BoolProperty(name='Edit',description="Show Edit options", default=False,update=updt_bool_panel_edit)
    bool_panel_save : BoolProperty(name='Save',description="Show save options", default=False,update=updt_bool_panel_save)
    bool_panel_import : BoolProperty(name='Import',description="Show Import options", default=False,update=updt_bool_panel_import)
    bool_panel_export : BoolProperty(name='Export',description="Show Export options", default=False,update=updt_bool_panel_export)
    bool_panel_load : BoolProperty(name='Load',description="Show load options", default=False,update=updt_bool_panel_load)

    bool_export_hair_preset : BoolProperty(name='Export Hair Preset',description="Export Hair Preset", default=False,update=updt_bool_export_hair_preset)
    bool_export_hair_style : BoolProperty(name='Export Hair Style',description="Export Hair Style", default=False,update=updt_bool_export_hair_style)
    bool_export_hair_children : BoolProperty(name='Export Hair Children',description="Export Hair Children", default=False,update=updt_bool_export_hair_children)
    bool_export_hair_shape : BoolProperty(name='Export Hair Shape',description="Export Hair Shape", default=False,update=updt_bool_export_hair_shape)

    bool_editmode_path : BoolProperty(name='Mode Path',description="Mode Path", default=True,update=updt_bool_editmode_path)
    bool_editmode_point : BoolProperty(name='Mode Point',description="Mode Point", default=False,update=updt_bool_editmode_point)
    bool_editmode_tip : BoolProperty(name='Mode Tip',description="Mode Tip", default=False,update=updt_bool_editmode_tip)

    bool_children_none: BoolProperty(name='None',description="Children None", default=True,update=updt_bool_children_none)
    bool_children_simple: BoolProperty(name='Simple',description="Children Simple", default=False,update=updt_bool_children_simple)
    bool_children_interpolated: BoolProperty(name='Interpolated',description="Children Simple", default=False,update=updt_bool_children_interpolated)

    bool_children_parting : BoolProperty(name='Parting',description="Children Parting", default=False,update=updt_bool_children_parting)
    bool_children_clumping : BoolProperty(name='Clumping',description="Children Clumping", default=False,update=updt_bool_children_clumping)
    bool_children_roughness : BoolProperty(name='Roughness',description="Children Roughness", default=False,update=updt_bool_children_roughness)
    bool_children_kink : BoolProperty(name='Kink',description="Children Kink", default=False,update=updt_bool_children_kink)

    #####Chidren options
    int_children_display_amount : IntProperty(default=10, name="Amount of children particles to Display",min=0,update=updt_children_display_amount)
    int_children_render_amount : IntProperty(default=100, name="Amount of children particles to Render",min=0,update=updt_children_render_amount)
    float_children_length : FloatProperty(default=1.0,precision=4, name="Length",min=0.0,max=1.0,update=updt_children_length)
    float_children_threshold : FloatProperty(default=0.0,precision=4, name="Threshold",min=0.0,max=1.0,update=updt_children_threshold)
    int_children_seed : IntProperty(default=0, name="Seed",min=0,update=updt_children_seed)
    #only for interpolated
    float_children_virtual_parents : FloatProperty(default=0.0,precision=4, name="Virtual Parents",min=0.0,max=1.0,update=updt_children_virtual_parents)
    bool_children_long_hair : BoolProperty(default=False,name="Long Hair",update=updt_children_long_hair)
    # only for simple
    float_children_size : FloatProperty(default=1.0,precision=4, name="Size",min=0.001,max=100000.0,update=updt_children_size)
    float_children_random_size : FloatProperty(default=0.0,precision=4, name="Random Size",min=0.0,max=1.0,update=updt_children_random_size)
    float_children_radius : FloatProperty(default=0.2,precision=4, name="Radius",min=0.0,max=100000.0,update=updt_children_radius)
    float_children_roundness : FloatProperty(default=0.0,precision=4, name="Roundness",min=0.0,max=1.0,update=updt_children_roundness)


    ### Children Parting
    ### Obs, se virtual parents estiver em uso, desabilitar Parting
    float_children_parting_parting : FloatProperty(default=0.0,precision=4, name="Parting",min=0.0,max=1.0,update=updt_children_parting_parting)
    float_children_parting_min : FloatProperty(default=0.0,precision=4, name="Min",min=0.0,max=180.0,update=updt_children_parting_min)
    float_children_parting_max : FloatProperty(default=0.0,precision=4, name="Max",min=0.0,max=180.0,update=updt_children_parting_max)

    ### Clumping
    ## se clump curve em uso, desabilitar as duas opcoes abaixo
    float_children_clump_clump : FloatProperty(default=0.0,precision=4, name="Clump",min=-1.0,max=1.0,update=updt_children_clump_clump)
    float_children_clump_shape : FloatProperty(default=0.0,precision=4, name="Shape",min=-1.0,max=1.0,update=updt_children_clump_shape)
    bool_children_clump_noise : BoolProperty(default=False,name="Noise",update=updt_children_clump_noise)
    float_children_clump_noise_size : FloatProperty(default=0.0,precision=4, name="Noise Size",min=0.0,max=100000.0,update=updt_children_clump_noise_size)
    #somente se tiver em simple
    float_children_clump_twist : FloatProperty(default=0.0,precision=4, name="Twist",min=-100000.0,max=100000.0,update=updt_children_clump_twist)

    ### Roughness
    ### checar quais opcoes desabilitar caso roughness curve esteja habilitado
    float_children_roughness_uniform : FloatProperty(default=0.0,precision=4, name="Uniform",min=0.0,max=100000.0,update=updt_children_roughness_uniform)
    float_children_roughness_size : FloatProperty(default=1.0,precision=4, name="Size",min=0.010,max=100000.0,update=updt_children_roughness_size)
    float_children_roughness_endpoint : FloatProperty(default=0.0,precision=4, name="Endpoint",min=0.0,max=100000.0,update=updt_children_roughness_endpoint)
    float_children_roughness_shape : FloatProperty(default=1.0,precision=4, name="Shape",min=0.0,max=10.0,update=updt_children_roughness_shape)
    float_children_roughness_random : FloatProperty(default=0.0,precision=4, name="Random",min=0.0,max=100000.0,update=updt_children_roughness_random)
    float_children_roughness_size2 : FloatProperty(default=1.0,precision=4, name="Size2",min=0.010,max=100000.0,update=updt_children_roughness_size2)
    float_children_roughness_threshold : FloatProperty(default=0.0,precision=4, name="Threshold",min=0.0,max=1.0,update=updt_children_roughness_threshold)

    ### Kink
    bool_children_kink_nothing : BoolProperty(default=True,name="Nothing",update=updt_children_kink_nothing)
    bool_children_kink_curl : BoolProperty(default=False,name="Curl",update=updt_children_kink_curl)
    bool_children_kink_radial : BoolProperty(default=False,name="Radial",update=updt_children_kink_radial)
    bool_children_kink_wave : BoolProperty(default=False,name="Wave",update=updt_children_kink_wave)
    bool_children_kink_braid : BoolProperty(default=False,name="Braid",update=updt_children_kink_braid)
    bool_children_kink_spiral : BoolProperty(default=False,name="Spiral",update=updt_children_kink_spiral)
    #### kink options
    float_children_kink_amplitude : FloatProperty(default=0.2,precision=4, name="Amplitude",min=-10.0,max=10.0,update=updt_children_kink_amplitude)
    float_children_kink_clump : FloatProperty(default=1.0,precision=4, name="Clump",min=0.0,max=1.0,update=updt_children_kink_clump)
    float_children_kink_flatness : FloatProperty(default=0.0,precision=4, name="Flatness",min=0.0,max=1.0,update=updt_children_kink_flatness)
    float_children_kink_frequency : FloatProperty(default=2.0,precision=4, name="Frequency",min=-100000.0,max=100000.0,update=updt_children_kink_frequency)
    float_children_kink_shape : FloatProperty(default=0.0,precision=4, name="Shape",min=-0.999,max=0.999,update=updt_children_kink_shape)
    ### kink optiions apenas para SPIRAL
    float_children_kink_amplitude_random : FloatProperty(default=0.0,precision=4, name="Amplitude Random",min=0.0,max=1.0,update=updt_children_kink_amplitude_random)
    enum_children_kink_axis : EnumProperty(
        name="Spiral Axis",
        description="Kink Spiral Axis",
        items={
            ('X','X','X'),
            ('Y','Y','Y'),
            ('Z','Z','Z'),
        }
        ,update=updt_enum_children_kink_axis
        )
    float_children_kink_axis_random : FloatProperty(default=0.0,precision=4, name="Axis Random",min=0.0,max=1.0,update=updt_children_kink_axis_random)
    int_children_kink_axis_steps : IntProperty(default=4, name="Axis Random",min=1,update=updt_children_kink_axis_steps)

    bool_show_save_hair_children_panel: BoolProperty(default=False, name="Show Save Hair Children Panel",update=updt_show_save_hair_children_panel)
    bool_show_load_hair_children_panel: BoolProperty(default=False, name="Show Load Hair Children Panel",update=updt_show_load_hair_children_panel)
    str_save_hair_children_preset_name: StringProperty(name="Name for Hair Children", description="Name to save the hair Children preset")

    enum_hair_children_presets : EnumProperty(
        name="Hair Children Preset Load",
        description="Choose a hair Children preset to load ",
        items=preset_hair_children_files_callback
        )

    bool_check_point_local_hair_children: BoolProperty(default=True, name='Local', description='Enable Local Checkpoint or Global, on global, the settings are copied to use on other particlesystem')
    str_global_checkpoint_hair_children: StringProperty(name="Hair Children Global Checkpoint",description="Temporarily save hair Children settings globaly",default="")

    # ###### Hair Shape
    float_hair_strand_shape : FloatProperty(default=0.0, name="Strand Shape",min=-1.0,max=1.0,precision=4,update=updt_hair_strand_shape)
    float_hair_strand_diameter_root : FloatProperty(default=1.0, name="Diameter Root",min=0.0,precision=4,update=updt_hair_strand_diameter_root)
    float_hair_strand_diameter_tip : FloatProperty(default=0.0, name="Diameter Tip",min=0.0,precision=4,update=updt_hair_strand_diameter_tip)
    float_hair_strand_diameter_scale : FloatProperty(default=0.01, name="Diameter Scale",min=0.0,precision=4,update=updt_hair_strand_diameter_scale)
    bool_hair_strand_close_tip : BoolProperty(default=True, name="Close Tip",update=updt_hair_strand_close_tip)

    bool_show_save_hair_shape_panel: BoolProperty(default=False, name="Show Save Hair Shape Panel",update=updt_show_save_hair_shape_panel)
    bool_show_load_hair_shape_panel: BoolProperty(default=False, name="Show Load Hair Shape Panel",update=updt_show_load_hair_shape_panel)

    bool_check_point_local_hair_shape: BoolProperty(default=True, name='Local', description='Enable Local Checkpoint or Global, on global, the settings are copied to use on other particlesystem')
    str_global_checkpoint_hair_shape: StringProperty(name="Hair Shape Global Checkpoint",description="Temporarily save hair shape settings globaly",default="")
    
    str_save_hair_shape_preset_name: StringProperty(name="Name for Hair Shape", description="Name to save the hair shape preset")
    
    enum_hair_shape_presets : EnumProperty(
        name="Hair Shape Preset Load",
        description="Choose a hair shape preset to load ",
        items=preset_hair_shape_files_callback
        )

    ##### Button to show hair options:
    bool_hair_part_mode_opt : BoolProperty(default=False, name="Particle Edit Options")#,update=updt_hair)
    bool_hair_opt : BoolProperty(default=True, name="Hair",update=updt_hair_opt)
    bool_children_opt : BoolProperty(default=False, name="Children",update=updt_children_opt)
    bool_hair_shape_opt : BoolProperty(default=False, name="Shape",update=updt_hair_shape_opt)

    
    ###### Length control options
    # bool_hair_length_grow : BoolProperty(name="Grow")#,update=updt_hair)
    # bool_hair_length_shrink : BoolProperty(name="Shrink")#,update=updt_hair)

    int_rekey_number : IntProperty(default=2, name="Rekey Particles",min=2,max=100)#,update=updt_)

    bool_stop_loop: BoolProperty(default=False,name="Stop Loop",description='Stop playback loop')
    
    bool_enable_shapekey: BoolProperty(default=False,name="Enable Shapekey Influence",description='Enable Shapekey Influence Control')
    bool_absolute_shapekey: BoolProperty(default=False,name="Enable Absolute Shapekey Influence",description='Enable Shapekey Absolute Influence')

    ###########
    ### VFX Grace 3d Hair Brush Control

    vfxgrace_bool_3d_brush: BoolProperty(default=True,name="3d Brush",update=updt_vfxgrace_bool_3d_brush)
    vfxgrace_bool_auto_switch: BoolProperty(default=True,name="Auto Switch",description='Auto Switch',update=updt_vfxgrace_bool_auto_switch)
    vfxgrace_bool_brush_scale: BoolProperty(default=False,name="Brush Scale", description='Brush Scale',update=updt_vfxgrace_bool_brush_scale)
    
    

####### UI List
class ListItem(PropertyGroup):
    """Group of properties representing an item in the list."""

    name: StringProperty(
        name="Name",
        description="A name for this item",
        default="Untitled"
        ,update=updt_list_name)

    # random_prop: StringProperty(
    #     name="Any other property you want",
    #     description="",
    #     default="")
    particle_system_id : IntProperty(
        name="Position of Particle System on Blender default List"
    )
    orig_name: StringProperty(
        name="Original Name",
        description="Original Particle Name",
        default="Untitled")

    checkpoint_hair_shape: StringProperty(
        name="Hair Shape Checkpoint",
        description="Temporarily save hair shape settings",
        default="")

    checkpoint_hair_children: StringProperty(
        name="Hair Children Checkpoint",
        description="Temporarily save hair Children settings",
        default="")

    bool_lock_hair_layer : BoolProperty(
        name="Lock the hair layer"
        ,default=True
    )

### Particle shapekeys
class ParticleShapeKeys(PropertyGroup):
    """Group of properties representing an item in the list."""

    partic_name: StringProperty(
        name="Name",
        description="A name for this Shapekey",
        default="Untitled Shapekey")

    partic_id : IntProperty(
        name="Position of Particle System on Blender default List"
    )
    partic_data: StringProperty(
        name="Data Hair Keys",
        description="Data with the information of the hair keys",
        default="")
    partic_shapekey_influence : FloatProperty(
        default=0.0,
        min=0.0,
        max=1.0,
        name="Shapekey Influence",
        description="Influence of the current shapekey",
        # update=updt_shapekey_influence
        update=updt_shapekey_influence_full_stack
    )
    partic_data_post_influence: StringProperty(
        name="Data Hair Keys after apply influence",
        description="Data with the information of the hair keys after influence",
        default="")
    